// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// naming.C
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   NamingScope
//
// Notes:
//   This module contains implementation of classes declared in naming.h
//   
// ----------------------------------------------------------------------------

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "stringary.h"
#include "naming.h"

int NamingScope::compare(const void *e1, const void *e2)
{
  int i, j;
  char *s1 = *((char **)e1), *s2 = *((char **)e2);
  
  do
    s1 = strchr(s1, '_') + 1;
  while(*s1 != '_');
  do
    s2 = strchr(s2, '_') + 1;
  while(*s2 != '_');
  ++s1;
  ++s2;
  
  while(1) {
    if((i = (int)strtol(s1, &s1, 10)) != (j = (int)strtol(s2, &s2, 10)))
      return i - j;
    if((i = *s1) == '_' && *s2 == '_') {
      ++s1;
      ++s2;
    }
    else
      return i == '.' || i == '\0' ? -1 : 1;
  }
}

int NamingScope::isValid(const char *objectName, const char *fileName,
			 const char *ending)
{
  int i = 0, c, f = 0, l, state = 0;

  if(objectName == NULL) {
    c = getNameLength(fileName);
    strncpy((char *)(objectName = new char[c + 1]), fileName, c)[c] = '\0';
    f = 1;
  }

  if(!strncmp(objectName, fileName, l = strlen(objectName))) {
    c = fileName[l];
    do {
      switch(state) {
      case 0:
	if(c == '_')
	  state = 1;
	break;
      case 1:
	state = c == '_' ? 2 : 0;
	break;
      case 2:
	if(isdigit(c)) {
	  state = 3;
	  ++i;
	}
	else
	  state = 0;
	break;
      case 3:
	if(c == '_')
	  state = 2;
	else if(c == '.')
	  state = strcmp(&fileName[l + 1], ending) ? 0 : 4;
	else if(!isdigit(c))
	  state = 0;
	break;
      }
      c = fileName[++l];
    }
    while(state != 0 && state != 4 && c != '\0');
    if(state == 4) {
      if(f)
	delete[] (char *)objectName;
      return i;
    }
  }

  if(f)
    delete[] (char *)objectName;
     
  return 0;
}

int NamingScope::getNameLength(const char *fileName)
{
  int i = 0, c = fileName[0], l = 0, state = 0;
  
  do {
    switch(state) {
    case 0:
      if(c == '_')
	state = 1;
      break;
    case 1:
      if(c == '_') {
	state = 2;
	l -= 2;
      }
      else
	state = 0;
    }
    c = fileName[++l];
  }
  while(c != 0 && state != 2);

  return l;
}

int NamingScope::getParam(const char *fileName, int k)
{
  do
    fileName = strchr(fileName, '_') + 1;
  while(*fileName != '_');
  ++fileName;
  for(int i = 1; i <= k; ++i)
    fileName = strchr(fileName, '_') + 1;
  return (int)strtol(fileName, 0, 10);
}

void NamingScope::sort(StringAry *fnames)
{
  qsort(fnames -> d_data_p, fnames -> d_size, sizeof(char *), compare);
}
