// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// ioutil.h
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   IOUtil
//
// Notes:
//   This header includes declarations for the static class IOUtil. IOUtil
//   serves as a scope for functions for loading/saving Persistent objects
//   from/to disk.
//
// ----------------------------------------------------------------------------

#ifndef IOUTIL_INCLUDED
#define IOUTIL_INCLUDED

#ifndef ERRORSCOPE_INCLUDED
#include "errorscope.h"
#endif

class Persistent;
class Handle;

class IOUtil : public ErrorScope {

  // Public Members

public:

  static Error get(Persistent*, const char *fileName);
  // load object with fileName in pointer

  static Error get(Handle*, const char *fileName);
  // load object with fileName in Handle

  static Error put(const Persistent&, const char *fileName);
  // save object with fileName

};

#endif
