// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// interpolation.h
//
// Author:               Sameer Nene
// Date:                 05/25/94
// Version:              1.0
// Modification History:
//   06/21/94 Interpolation is no longer derived from Persistent, so that
//            interpolations are not forced to be persistents.
//
// Bugs:
//
// Classes:
//   Interpolation
//
// Notes:
//   This header includes declarations for the virtual base class
//   Interpolation. Note that since Interpolation is a protocol class, there is
//   no implementation. The Interpolation heirarchy is used to implement a
//   consistent interface for various interpolation schemes such as splines,
//   linear, etc. The most useful method is sample().
//   
// ----------------------------------------------------------------------------

#ifndef INTERPOLATION_INCLUDED
#define INTERPOLATION_INCLUDED

class Vector;

class Interpolation {

  // Public Members

public:

  // Destructor

  virtual ~Interpolation() {}

  // Accessors

  virtual int hasInterpolationProtocol(void *protocol) const = 0;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol
  
  virtual Vector sample(const Vector&) const = 0;
  // samples interpolation with supplied set of parameters and returns
  // sampled point

  virtual int dimension() const = 0;
  // returns dimensionality of the interpolation

  virtual int spaceDimension() const = 0;
  // returns dimensionality of the space of the interpolation
  
};

#endif
