// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// handle.C
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//   Using set might introduces a memory leak, because the previous Persistent
//   object is not deleted. This is not necessarily a bug, because this is
//   often required.
//
//   Note however that if a handle is destroyed (deleted), then the object
//   contained by the handle is also destroyed (deleted).
//
// Classes:
//   Handle
//
// Notes:
//   This module contains implementation of classes declared in handle.h
//   
// ----------------------------------------------------------------------------

#include "persistent.h"
#include "handle.h"

Handle::Handle() : d_persistent_p(0)
{
}

Handle::Handle(Persistent *p) : d_persistent_p(p)
{
}

Handle::~Handle()
{
  delete d_persistent_p;
  d_persistent_p = 0;
}

Persistent* Handle::operator()() const
{
  return d_persistent_p;
}

void Handle::set(Persistent *p)
{
  d_persistent_p = p;
}
