// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// fileiter.h
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// ToDo:
//   Have a new class called FileListAryIter, thereby making access of multiple
//   sets more convenient.
//
// Classes:
//   FileList
//   FileListAry
//   FileListIter
//
// Notes:
//   This header includes declarations for the class FileList, FileListAry and
//   FileListIter. These are used to maintain and access lists of
//   images/vectors/etc and lists of image/vector/etc sets respectively.
//   FileListIter is used to iterate over individual files in a FileList.
//   
// ----------------------------------------------------------------------------

#ifndef INCLUDED_FILEITER
#define INCLUDED_FILEITER

#ifndef INCLUDED_ERRORSCOPE
#include "errorscope.h"
#endif

class StringAry;
class FileListIter;

class FileList : public ErrorScope {

  // Private members
  
  int d_catpos, d_nparam, *d_psizes_p;
  Error d_error;
  char *d_dir_p;
  StringAry *d_fnames_p;

  // FileLists cannot be copied or assigned

  FileList(const FileList&);
  FileList& operator=(const FileList&);

  // Friends

friend FileListIter;

  // Public members

public:

  // Construct & Destroy

  FileList(const char *dirName, const char *objectName, const char *ending);
  ~FileList();

  // Accessors

  int getSize() const;
  // returns total number of files

  int getSize(int i) const;
  // returns size of parameter i

  int getNumParam() const;
  // returns number of parameters

  Error error() const;
  // returns error status
  
};

class FileListAry : public ErrorScope {

  // Private members

  int d_size;
  FileList **d_data_p;
  Error d_error;

  // FileListArys cannot be copied or assigned

  FileListAry(const FileListAry&);
  FileListAry& operator=(const FileListAry&);

  // Public members

public:

  // Construct & Destroy

  FileListAry(const char *dirName, const StringAry&, const char *ending);
  ~FileListAry();

  // Accessors

  const FileList& operator[](int) const;
  int getSize() const;

  Error error() const;
  // returns error status
    
};

class FileListIter {

  // Private members

  int d_element;
  const FileList &d_fl;

  // FileListIters cannot be copied or assigned

  FileListIter(const FileListIter&);
  FileListIter& operator=(const FileListIter&);

  // Public Functions

public:

  // Construct & Destroy

  FileListIter(const FileList&);
  ~FileListIter();
  
  // Manipulator

  void operator++();
  void operator--();
  void reset();

  // Accessor

  operator const void*() const;
  // returns 0 if no more files else returns non-null

  const char* operator()() const;
  // returns current filename

};

#endif
