// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// fileinfo.h
//
// Author:               Sameer Nene
// Date:                 08/06/94
// Version:              1.0
//
// Bugs:
//
// ToDo:
//
// Classes:
//   FileInfo
//
// Notes:
//   This header includes declarations for class FileInfo.
//   
// ----------------------------------------------------------------------------

#ifndef FILEINFO_INCLUDED
#define FILEINFO_INCLUDED

class FileInfo {

  char *d_name_p, *d_dir_p;
  int d_type;

  // FileInfos cannot be copied or assigned
  FileInfo(const FileInfo&);
  const FileInfo& operator=(const FileInfo&);

public:

  enum {BINARY, TEXT};

  // Construct and destroy
  
  FileInfo();
  FileInfo(const char *dir, const char *name, int type);
  ~FileInfo();


  // Modifiers

  void setName(const char*);
  void setDirName(const char*);
  void setType(int);

  // Accessors

  const char* getName() const;
  const char* getDirName() const;
  int getType() const;

};

#endif
