// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// fileinfo.C
//
// Author:               Sameer Nene
// Date:                 08/06/94
// Version:              1.0
//
// Bugs:
//
// ToDo:
//
// Classes:
//   FileInfo
//
// Notes:
//   This module contains implementation of classes declared in fileinfo.h
//   
// ----------------------------------------------------------------------------

#include <string.h>
#include "fileinfo.h"

FileInfo::FileInfo() : d_name_p(0), d_dir_p(0), d_type(0)
{
}

FileInfo::FileInfo(const char *dir, const char *name, int type) :
d_name_p(strcpy(new char[strlen(name) + 1], name)),
d_dir_p(strcpy(new char[strlen(dir) + 1], dir)), d_type(type)
{
}

FileInfo::~FileInfo()
{
  delete[] d_name_p;
  delete[] d_dir_p;
}

void FileInfo::setName(const char *name)
{
  delete[] d_name_p;
  d_name_p = strcpy(new char[strlen(name) + 1], name);
}

void FileInfo::setDirName(const char *name)
{
  delete[] d_dir_p;
  d_dir_p = strcpy(new char[strlen(name) + 1], name);
}

void FileInfo::setType(int type)
{
  d_type = type;
}

const char* FileInfo::getName() const
{
  return d_name_p;
}

const char *FileInfo::getDirName() const
{
  return d_dir_p;
}

int FileInfo::getType() const
{
  return d_type;
}
