// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// errorscope.C
//
// Author:               Sameer Nene
// Date:                 05/17/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   ErrorScope
//
// Notes:
//   This module contains implementation of all classes in errorscope.h.
//   
// ----------------------------------------------------------------------------

#include <iostream.h>
#include "errorscope.h"

ostream& operator<<(ostream& o, ErrorScope::Error err)
{
  switch(err) {
  case ErrorScope::OK:
    o << "Operation successful";
    break;
  case ErrorScope::FILE_OPEN_ERROR:
    o << "Error in opening file";
    break;
  case ErrorScope::FILE_CLOSE_ERROR:
    o << "Error in closing file";
    break;
  case ErrorScope::INCORRECT_FORMAT:
    o << "Incorrect file format";
    break;
  case ErrorScope::FILE_READ_ERROR:
    o << "Error in reading file";
    break;
  case ErrorScope::FILE_WRITE_ERROR:
    o << "Error in writing file";
    break;
  case ErrorScope::DIRECTORY_OPEN_ERROR:
    o << "Error in opening directory";
    break;
  case ErrorScope::DEVICE_OPEN_ERROR:
    o << "Error in opening device";
    break;
  case ErrorScope::DEVICE_CLOSE_ERROR:
    o << "Error in closing device";
    break;
  case ErrorScope::DEVICE_FUNCTION_ERROR:
    o << "Error in device operation";
    break;
  case ErrorScope::DEVICE_READ_ERROR:
    o << "Error in reading from device";
    break;
  case ErrorScope::DEVICE_WRITE_ERROR:
    o << "Error in writing to device";
    break;
  case ErrorScope::PARAMETER_ERROR:
    o << "Error in supplied parameters";
    break;
  default:
    o << "Unknown Error. Should'nt occur. Please report to sameer@cs.columbia.edu";
  }

  return o;
}
      
