// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xreporter.h
//
// Author:               Sameer Nene
// Date:                 08/25/94
// Version:              1.0.0
// Modification History:
//
// Bugs:
//
// Classes:
//   XReporter
//
// Notes:
//   This header includes declarations for the static class XReporter.
//   XReporter serves as a scope for functions which do status reporting to
//   the outside world.
//
// ----------------------------------------------------------------------------

#ifndef XREPORTER_INCLUDED
#define XREPORTER_INCLUDED

#define NO_XMSTRINGS

#include <Xm/Xm.h>
#include <X11/Xlib.h>

class XReporter {

  // Private Members

  static int d_pos, d_bpressed, d_direc;
  static Cursor d_cursor;
  static Widget d_dialog, d_darea, d_button, d_messg, d_topshell, d_ind;

  static void int_cb(Widget, XtPointer, XtPointer);
  static void checkPendingEvents();
  static void updateStatus();

  enum {UP, DOWN};
  enum {STATUS_AREA_HEIGHT = 20, STATUS_POSITIONS = 10};
  
  // Public members

public:

  enum {INTERRUPTIBLE, NONINTERRUPTIBLE};
  enum {BUTTONPRESSED, NOBUTTONPRESSED};

  static void showWindow(Widget topshell, const char *message, int flag);
  static void showWaitCursor(Widget topshell);
  static int display_status();
  static int display_status(const char *message);
  static int get_key_status();
  static void destroyWindow();
  static void showNormalCursor(Widget topshell);

};

#endif

