// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xmksrchtblut.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module for computation of Search structures
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <string.h>
#include <Xm/Xm.h>
#include "list.h"
#include "fileinfo.h"

void fillList(Widget listbox, const List<FileInfo* > &list)
{
  int i;
  XmString *names;

  ListIter<FileInfo* > it(list);
  for(i = 0, names = new XmString[list.length()]; it; ++it, ++i)
    names[i] = XmStringCreateSimple((char *)(it() -> getName()));
  XtVaSetValues(listbox, XmNitems, names, XmNitemCount, i, NULL);
  
  while(i--)
    XmStringFree(names[i]);
  delete[] names;
}

void get_path(XmFileSelectionBoxCallbackStruct *p1, char **dir, char **name)
{
  char *p2, *p3, *mdir;
  
  XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)p1) -> dir,
		  XmSTRING_DEFAULT_CHARSET, &mdir);
  XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)p1) -> value,
		  XmSTRING_DEFAULT_CHARSET, &p2);
  if(*p2 == '/') {
    p3 = strrchr(p2, '/') + 1;
    strcpy(*name = new char[strlen(p3) + 1], p3);
    *p3 = '\0';
    strcpy(*dir = new char[strlen(p2) + 1], p2);
  }
  else {
    if((p3 = strrchr(p2, '/')) == NULL)
      p3 = p2;
    else
      ++p3;
    strcpy(*dir = new char[strlen(mdir) + 1], mdir);
    strcpy(*name = new char[strlen(p3) + 1], p3);
  }
  XtFree(mdir);
  XtFree(p2);
}
