// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xmksrchtbl.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module for computation of Search structures
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/TextF.h>
#include <Xm/Xm.h>
#include "xmksrchtbl.h"
#include "fileinfo.h"

extern void compute_cb(Widget, XtPointer, XtPointer);
extern void quit_cb(Widget, XtPointer, XtPointer);
extern void pulldown_cb(Widget w, XtPointer, XtPointer);
extern void popup_cb(Widget, XtPointer p1, XtPointer);
extern void hmenu_cb(Widget, XtPointer, XtPointer);
extern void typeoptionB_cb(Widget, XtPointer p1, XtPointer);
extern void typeoptionT_cb(Widget, XtPointer p1, XtPointer);
extern void loadDataSetOk_cb(Widget, XtPointer, XtPointer);
extern void delItem_cb(Widget w, XtPointer p1, XtPointer);
extern void typeoptionES_cb(Widget, XtPointer p1, XtPointer);
extern void typeoptionHS_cb(Widget, XtPointer p1, XtPointer);
extern void typeoptionBS_cb(Widget, XtPointer p1, XtPointer);

void err_dlg(Widget parent, const char *s)
{
  XmString mesg = XmStringCreateSimple((char *)s);
  Widget dlg;

  dlg = XmCreateErrorDialog(parent, "Error", NULL, 0);
  XtVaSetValues(dlg,
		XmNmessageString, mesg,
		XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		NULL);
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_HELP_BUTTON));

  XmStringFree(mesg);
  XtManageChild(dlg);
}

Widget createLoadDataSetDialog(Widget w, MainCbLocal *data)
{
  XmString str1;
  Widget topshell, topwin, filesb, optionMenu, optionType, type1, type2;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Data Set...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			    NULL);

  optionType = XmCreatePulldownMenu(topwin, "options", NULL, 0);
  str1 = XmStringCreateSimple("File Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNtopOffset, 10);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNleftOffset, 10);
  optionMenu = XmCreateOptionMenu(topwin, "typeoption", args, 6);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &(data -> d_type));
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &(data -> d_type));

  str1 = XmStringCreateSimple("*.smp");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, loadDataSetOk_cb, data);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

int main(int argc, char **argv)
{
  static MainCbLocal data;
  XtAppContext app;
  Widget topshell, topwin, form1, button1, button2, button3, sep1, form2,
  form3, form4, label1, text1, listbox, dialog1, optionMenu, optionType, type1,
  type2, type3;
  XmString str1;
  Arg args[4];

  topshell = XtAppInitialize(&app, "xeigen", NULL, 0, &argc, argv, NULL,
			     (ArgList)NULL, (Cardinal)0);
  data.d_topshell = topshell;

  topwin = XtVaCreateWidget("mainform", xmFormWidgetClass, topshell, NULL);

  dialog1 = createLoadDataSetDialog(topwin, &data);

  label1 = XtVaCreateManagedWidget("SLAM - Sameer A. Nene, Shree K. Nayar, Hiroshi Murase",
				   xmLabelGadgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNbottomOffset, 5,
				   NULL);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, label1,
				 XmNbottomOffset, 5,
				 NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   NULL);
  button1 = XtVaCreateManagedWidget("Compute", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 9,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, compute_cb, &data);
  button2 = XtVaCreateManagedWidget("Quit", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 4,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 6,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 9,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, quit_cb, 0);
  button3 = XtVaCreateManagedWidget("About...", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 7,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 9,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 9,
				    NULL);
  XtAddCallback(button3, XmNactivateCallback, hmenu_cb, 0);
  XtManageChild(form1);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form1,
				 NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   NULL);

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNbottomOffset, 10,
			   NULL);
  optionType = XmCreatePulldownMenu(form2, "options", NULL, 0);
  str1 = XmStringCreateSimple("Search Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNleftAttachment, XmATTACH_FORM);
  optionMenu = XmCreateOptionMenu(form2, "typeoption", args, 4);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("Exhaustive",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionES_cb, &data.d_srchtype);
  type2 = XtVaCreateManagedWidget("Heuristic",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionHS_cb, &data.d_srchtype);
  type3 = XtVaCreateManagedWidget("Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type3, XmNactivateCallback, typeoptionBS_cb, &data.d_srchtype);

  label1 = XtVaCreateManagedWidget("Mapping Parameters", xmLabelGadgetClass, form2,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form2,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, label1,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text = text1;
  XtManageChild(form2);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNorientation, XmVERTICAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNtopAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_WIDGET,
				 XmNrightWidget, form2,
				 XmNrightOffset, 10,
				 XmNbottomAttachment, XmATTACH_FORM,
				 NULL);
				 
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNbottomOffset, 10,
			   XmNrightAttachment, XmATTACH_WIDGET,
			   XmNrightWidget, sep1,
			   NULL);
  label1 = XtVaCreateManagedWidget("Data Sets", xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form2,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, label1,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form3,
			   XmNfractionBase, 8,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Add...", xmPushButtonGadgetClass, form4,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 2,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 7,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, popup_cb, dialog1);
  button2 = XtVaCreateManagedWidget("Delete", xmPushButtonGadgetClass, form4,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 5,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 7,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, delItem_cb, &data);
  XtManageChild(form4);

  data.d_listw = listbox = XmCreateScrolledList(form3, "list", NULL, 0);
  XtVaSetValues(listbox,
		XmNvisibleItemCount, 7,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNselectionPolicy, XmEXTENDED_SELECT,
		NULL);
  XtVaSetValues(XtParent(listbox),
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, form4,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
  XtManageChild(listbox);

  XtManageChild(form3);
  
  XtManageChild(form2);

  XtManageChild(form1);

  XtManageChild(topwin);
  XtRealizeWidget(topshell);

  data.d_type = FileInfo::BINARY;

  XtAppMainLoop(app);

  return 0;
}
