// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xmanifold.h
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module for visualization/manipulation of manifolds/projections
//   
// ----------------------------------------------------------------------------

#ifndef XMFOLD_INCLUDED
#define XMFOLD_INCLUDED

#ifndef INCLUDED_LIST
#include "list.h"
#endif

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

class FileList;
class FileListIter;
class NamedDataSet;
class NamedInterpolation;

#include <X11/Intrinsic.h>
#include <X11/PEX5/PEXlib.h>

struct RadioBoxLocal {
  int d_sel;
  int d_typesel;
  Widget d_fileSelBox;
  Widget d_toggleb;
  Widget d_list;
  Widget d_type1;
  Widget d_type2;
};

struct FitManifoldCbLocal {
  Widget d_text1;
  Widget d_text2;
  Widget d_text[3];
  Widget d_list;
};

struct ExposeCbLocal {
  double d_theta;
  double d_phi;
  double d_alpha;
  double d_sx;
  double d_sy;
  double d_sz;
  double d_tx;
  double d_ty;
  double d_tz;
  double d_tx2;
  double d_ty2;
  double d_tz2;
  PEXRenderer renderer;
  PEXStructure axisSid;
  PEXStructure labelsSid;
  PEXViewEntry d_view;
  PEXLookupTable d_view_table;
  PEXCoord d_prp, d_min, d_max;
  PEXCoord2D d_vwin[2];
  PEXNPCSubVolume d_vport;
  int d_viewLabels;
};

struct ListSelCbLocal {
  Widget d_viList;
  Widget d_hdList;
};

struct ProjectCbLocal {
  Widget d_numVectorText;
  Widget d_useAvgBtn;
};

struct PrefCbLocal {
  Widget d_axisText[3];
  Widget d_selLabel;
  Widget d_paramText[3];
  Widget d_optionType[3];
  Widget d_optionMenu[3];
  NamedInterpolation *d_nip;
  int d_dmap[2];
  int d_prevValue;
  Vector d_param;
};

struct PrintBoxLocal {
  int d_bpressed;
  Widget d_text1;
  Widget d_text2;
};

struct OrthoCbLocal {
  char *d_dir_p;
  char *d_name_p;
};

class Global {
  
public:

  enum {NUM_STATIC_COLORS = 8};
  
  static Boolean d_pexavail;
  static char *d_text1;
  static char *d_text2;
  static char *d_text3_p[3];
  static int d_numeigen;
  static int d_dim1;
  static int d_dim2;
  static int d_dim3;
  static int d_sfreq[3];
  static int d_typesel;
  static int d_colIndex;
  static int d_vaindex;
  static int d_ftype;
  static double d_sx;
  static double d_sy;
  static double d_sz;
  static double d_tx;
  static double d_ty;
  static double d_tz;
  static Widget d_darea;
  static Widget d_label1;
  static Widget d_label2;
  static Widget d_label3;
  static Widget d_loadbox;
  static Widget d_savebox;
  static Widget d_loadVectorSetBox;
  static Widget d_loadVectorBox;
  static Widget d_loadEigenVectorBox;
  static Widget d_saveEigenVectorBox;
  static Widget d_topshell;
  static Widget d_prefbox;
  static Widget d_printBox;
  static Widget d_projbox;
  static Widget d_fitbox;
  static Widget d_samplebox;
  static Widget d_orthobox;
  static Widget d_menubar;
  static Widget d_text4[3];
  static Window d_drawin;
  static char *d_name;
  static char *d_dir;
  static Display *d_display;
  static XVisualInfo d_vinfo;
  static FileList *d_fl;
  static FileListIter *d_flit;
  static Vector *d_avg;
  static VectAry *d_va_p[2];
  static RadioBoxLocal *d_sbdata;
  static PEXColorRGB d_stColors[NUM_STATIC_COLORS];
  static List<NamedDataSet *> d_proj;
  static List<NamedInterpolation *> d_manifold;
};

#endif
