// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xeigenut.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module for computation of Eigenvectors
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <string.h>
#include <Xm/Xm.h>
#include "fileiter.h"
#include "list.h"
#include "naming.h"
#include "fileinfo.h"

void objectSearchProc(Widget w, XtPointer p1, XtPointer)
{
  char *p2, *p3;
  int f, i, j;
  XmString *files;
  
  XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)p1) -> dir,
		  XmSTRING_DEFAULT_CHARSET, &p3);
  FileList fl(p3, NULL, "vec");
  XtFree(p3);
  FileListIter it(fl);
  List<char* > namelist;
  for(i = 0; it; ++it) {
    p2 = strrchr(it(), '/');
    if(p2 != 0) {
      j = NamingScope::getNameLength(p2 + 1);
      p3 = strncpy(new char[j + 1], p2 + 1, j);
      p3[j] = '\0';
    }
    else {
      j = NamingScope::getNameLength(it());
      p3 = strncpy(new char[j + 1], it(), j);
      p3[j] = '\0';
    }
    ListIter<char* > it2(namelist);
    for(f = 0; it2; ++it2)
      if(strcmp(it2(), p3) == 0) {
	f = 1;
	break;
      }
    if(f == 0) {
      namelist += p3;
      ++i;
    }
    else
      delete[] p3;
  }
  ListIter<char* > it2(namelist);
  for(j = 0, files = new XmString[i]; it2; ++it2, ++j)
    files[j] = XmStringCreateSimple(it2());
  XtVaSetValues(w,
		XmNfileListItems, files,
		XmNfileListItemCount, i,
		XmNdirSpec, NULL,
		XmNlistUpdated, True,
		NULL);
  for(ListIter<char* > it3(namelist); it3; ++it3) {
    XmStringFree(files[--i]);
    delete[] it3();
  }
  delete[] files;
}

void fillList(Widget listbox, const List<FileInfo* > &list)
{
  int i;
  XmString *names;

  ListIter<FileInfo* > it(list);
  for(i = 0, names = new XmString[list.length()]; it; ++it, ++i)
    names[i] = XmStringCreateSimple((char *)(it() -> getName()));
  XtVaSetValues(listbox, XmNitems, names, XmNitemCount, i, NULL);
  
  while(i--)
    XmStringFree(names[i]);
  delete[] names;
}

void get_path(XmFileSelectionBoxCallbackStruct *p1, char **dir, char **name)
{
  char *p2, *p3, *mdir;
  
  XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)p1) -> dir,
		  XmSTRING_DEFAULT_CHARSET, &mdir);
  XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)p1) -> value,
		  XmSTRING_DEFAULT_CHARSET, &p2);
  if(*p2 == '/') {
    p3 = strrchr(p2, '/') + 1;
    strcpy(*name = new char[strlen(p3) + 1], p3);
    *p3 = '\0';
    strcpy(*dir = new char[strlen(p2) + 1], p2);
  }
  else {
    if((p3 = strrchr(p2, '/')) == NULL)
      p3 = p2;
    else
      ++p3;
    strcpy(*dir = new char[strlen(mdir) + 1], mdir);
    strcpy(*name = new char[strlen(p3) + 1], p3);
  }
  XtFree(mdir);
  XtFree(p2);
}
