// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// stringary.h
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   StringAry
//
// Notes:
//   This header includes declarations for the class StringAry. StringAry
//   provides a convenient abstraction for storage of arrays of Strings.
//   
// ----------------------------------------------------------------------------

#ifndef STRINGARY_INCLUDED
#define STRINGARY_INCLUDED

class NamingScope;

class StringAry {
  
  // Private data
  
  int d_size;
  char **d_data_p;

  // StringArys cannot be copied or assigned

  StringAry(const StringAry&);
  StringAry& operator=(const StringAry&);

  // Friends

friend NamingScope;
  
  // Public Members
  
public:
  
  StringAry(int size);
  ~StringAry();
  
  // Manipulator
  
  void set(int i, const char *);
  // Sets string at position i
  
  // Accessors
  
  int getSize() const;
  char* operator[](int) const;
  // returns the ith string. Note that the pointer returned is not a copy; ie
  // all operations on the string would affect the string held by the StringAry

};

#endif
