// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// searchutil.h
//
// Author:               Sameer Nene
// Date:                 05/26/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   SearchUtil
//
// Notes:
//   This header includes declarations for the class SearchUtil. SearchUtil is
//   mainly a convenience class. It is helpful when a program intends to
//   "blindly" load a search object, but it's type(or class) is unknown.
//   SearchUtil::setScheme() can be used to load the object. After this is
//   done, the SearchUtil object can be used to set the threshold and execute
//   a search.
//   
// ----------------------------------------------------------------------------

#ifndef SEARCHUTIL_INCLUDED
#define SEARCHUTIL_INCLUDED

#ifndef ERRORSCOPE_INCLUDED
#include "errorscope.h"
#endif

class Vector;
class VectAry;

#ifndef HANDLE_INCLUDED
#include "handle.h"
#endif

class SearchScheme;

class SearchUtil : public ErrorScope {

  // Private members

  Handle d_scheme;

  // SearchUtil cannot be copied or assigned
  
  SearchUtil(const SearchUtil&);
  SearchUtil& operator=(const SearchUtil&);

  // Public members

public:

  // Construct and destroy

  SearchUtil() {}
  ~SearchUtil() {}

  // Modifiers

  Error setScheme(const char *filename);
  // sets search method to the one constructed in filename

  // Accessors
  
  Vector search(const Vector &v) const;
  // searches for v and returns result vector

  const VectAry& getData() const;
  // returns reference to underlying data

  // Modifiers

  void setSearchParameters(const Vector &v) const;
  // Sets search parameters as defined by the appropriate underlying search
  // method

};

#endif

  
