// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// searchscheme.h
//
// Author:               Sameer Nene
// Date:                 05/26/94
// Version:              1.0
// Modification History:
//   06/25/94: SearchScheme is no longer derived from Persistent, so that
//             Searchschemes are not forced to be Persistents.
//
// Bugs:
//
// Classes:
//   SearchScheme
//
// Notes:
//   This header includes declarations for the virtual base class SearchScheme.
//   SearchScheme is used to define a protocol for various search techniques.
//   The currently defined methods are search() and setSearchParameters().
//   Also, since SearchScheme is a pure protocol, there is no implementation
//   (.C)
//   
// ----------------------------------------------------------------------------

#ifndef SEARCHSCHEME_INCLUDED
#define SEARCHSCHEME_INCLUDED

class Vector;
class VectAry;

class SearchScheme {

  // Public members

public:

  // Construct and destroy

  virtual ~SearchScheme() {}

  // Accessors
  
  virtual Vector search(const Vector &v) const = 0;
  // searches for v and returns result vector

  virtual const VectAry& getData() const = 0;
  // returns reference to underlying data

  // Modifiers

  virtual void setSearchParameters(const Vector &v) = 0;
  // sets a bunch of parameters passed in v for the search algorithms

};

#endif

  
