// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// postscript.h
//
// Author:               Sameer Nene
// Date:                 07/29/94
// Version:              1.0
//
// Bugs:
//
// ToDo:
//
// Classes:
//   PEXtoPSstream
//
// Notes:
//   This class generates PostScript code from PEX structures.
//   
// ----------------------------------------------------------------------------

#ifndef PEXTOPSSTREAM_INCLUDED
#define PEXTOPSTREAM_INCLUDED

#ifndef ERRORSCOPE_INCLUDED
#include "errorscope.h"
#endif

#include <stdio.h>
#include <X11/PEX5/PEXlib.h>

class PEXtoPSstream : public ErrorScope {

  // Private Members

  FILE *d_file_p;
  PEXMatrix d_ori;
  int d_markerType;
  double d_aTextHt, d_lineWidth, d_markerScale, d_sx, d_sy, d_tx, d_ty,
  d_pgWidth, d_pgHeight;
  PEXColor d_textCol, d_lineCol, d_markerCol, d_surfCol;

  void mapToPage(const PEXCoord*, PEXCoord*, int n);
  // map points from PEX space to page space

  // Public Members

public:

  // Construct & Destroy

  PEXtoPSstream(FILE*, double width, double height, const PEXCoord &min,
		const PEXCoord &max);
  // creates an object for PostScript output to FILE*. width and height are
  // used for setting the bounding box. min & max are used to supply a 3D
  // bounding box which encloses the PEX data. min, max, width and height are
  // together used to map PEX coordinates to PostScript page coordinates.

  ~PEXtoPSstream() {}

  void setView(const PEXViewEntry&);
  // sets the 3D viewing transform for projection of 3D PEX elements to 2D
  // PostScript

  Error writeHeader();
  // writes PostScript header and scaling information. Has to be issued before
  // *any* render operation.
  
  Error render(Display*, const PEXStructure&, int elemNum);
  // converts a PEX element elemNum, obtained from a PEX structure, to
  // PostScript

  Error showPage();
  // issues a final showpage command. This is to be used after all rendering
  // operations are done.

};

#endif
