// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// persistent.h
//
// Author:               Sameer Nene
// Date:                 05/23/94
// Version:              1.0
// Modification History:
// Bugs:
//
// ToDo:
//   Change the type of protocol from void* to the architecture independant
//   void *.
//
// Classes:
//   Persistent
//
// Notes:
//   This header includes declarations for the virtual base class Persistent.
//   Note that since Persistent is a protocol class, there is no implementation
//   This is the base class upon which the entire persistent hierarchy is
//   built. The persistent hierarchy facilitates in having a consistent method
//   to do I/O of objects; namely loading and storing objects from/to disks by
//   use of get() and put(). The rest of the methods help in maintaining the
//   hierarchy.
//   
// ----------------------------------------------------------------------------

#ifndef PERSISTENT_INCLUDED
#define PERSISTENT_INCLUDED

#ifndef ERRORSCOPE_INCLUDED
#include "errorscope.h"
#endif

#include <stdio.h>

class Persistent : public ErrorScope {

  // Public Members

public:

  // Destructor

  virtual ~Persistent() {}
  // made virtual for properly handling delete <Persistent *>
  
  // Manipulators

  virtual Error get(FILE*) = 0;
  // gets object from file

  // Accessors
  
  virtual Error put(FILE*) const = 0;
  // puts object in file

  virtual int hasProtocol(void* protocol) const = 0;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol
    
  virtual const char* name() const = 0;
  // returns the name of the class.

};

#endif
