// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// parser.h
//
// Author:               Sameer Nene
// Date:                 08/29/94
// Version:              1.0.3
//
// Modification History:
//   06/07/94: Added CommandParser::getVerboseFlag()
//             Added CommandParser::getTemporaryDirectory()
//   08/13/94: Deleted CommandParser::getTemporaryDirectory()
//             Added CommandParser::getEigenValueFilename()
//             Added CommandParser::getAverageFlag()
//             Added CommandParser::getEigenValueFlag()
//             Changes to the way CommandParser::getAverageVectorFileName()
//               returns values.
//   08/29/94: Added additional parameter to constructor to enable selective
//             supply of command-line options.
//
// Bugs:
//
// Classes:
//   CommandParser
//
// Notes:
//   This header includes declarations for the class CommandParser.
//   CommandParser is used to parse command line options. Various methods have
//   been provided to enable to read the supplied arguments.
//   
// ----------------------------------------------------------------------------

#ifndef INCLUDED_PARSER
#define INCLUDED_PARSER

#ifndef INCLUDED_ERRORSCOPE
#include "errorscope.h"
#endif

class StringAry;

class CommandParser : public ErrorScope {

  // Private Data

  Error d_error;
  int d_numeigen, d_mem, d_numvparams, d_numvalues, d_numsparams, d_numsvalues, d_cflag, d_aflag, d_vflag, d_lflag;
  double **d_vstart_p, **d_sstart_p, *d_values_p, *d_svalues_p;
  StringAry *d_nameary_p;
  char *d_avg_p, *d_eigen_p, *d_dir_p, *d_evl_p, *d_combine_p;

  // CommandParsers cannot be assigned or copied

  CommamdParser(const CommandParser&);
  CommandParser& operator=(const CommandParser&);

  // Public Members

public:
  
  CommandParser(int argc, char* const *argv, const char *opts = 0);
  ~CommandParser();

  // Accessors

  Error error() const;
  // returns non-zero in case of an error else returns zero

  char* getObjectDirectory() const;
  // Gets name of directory used for storing object files passed by -D option.
  // returns 0 if -D not supplied

  StringAry& getObjectList() const;
  // Gets names of objects supplied in command line

  char* getAverageVectorFileName() const;
  // Gets the filename prefix of the average vector. If the vector name is
  // supplied along with -a option, it returns that name. If no argument is
  // supplied with -a, it returns a default name, else returns 0.

  char* getEigenVectorFileName() const;
  // Gets the filename prefix of the eigen vectors

  char* getEigenValueFileName() const;
  // Gets the filename prefix of the eigen values

  int getNumEigenVectors() const;
  // Gets the number of eigen vectors to be computed

  int getMemRequired() const;
  // Gets memory to be used in Mb

  int getNumValueParams() const;
  // Gets the number of parameters giving value

  int getNumValues(int) const;
  // Gets the number of values for the supplied parameter number

  double getValue(int p, int i) const;
  // Gets the i th value of the p th parameter

  int getNumSampleValueParams() const;
  // Gets the number of parameters giving value

  int getNumSampleValues(int) const;
  // Gets the number of values for the supplied parameter number

  double getSampleValue(int p, int i) const;
  // Gets the i th value of the p th parameter

  int getAverageFlag() const;
  // returns the value of the average flag. True if -A is supplied
  
  int getCombineFlag() const;
  // returns the value of the combine flag. True if -C is supplied

  int getEigenValueFlag() const;
  // returns the value of the eigenvalue flag. True if -L is supplied

  int getVerboseFlag() const;
  // returns the value of the verbose flag. True if -V is supplied

  char *getCombineName() const;
  // Gets the parameter of the -c flag

};

#endif
