// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// ndataset.C
//
// Author:               Sameer Nene
// Date:                 08/28/94
// Version:              1.0
// Modification History:
//
// Bugs:
//
// Classes:
//   NamedDataSet
//
// Notes:
//   Private class. Not for public use.
//   
// ----------------------------------------------------------------------------

#include <X11/PEX5/PEXlib.h>
#include <string.h>
#include <values.h>
#include "dataset.h"
#include "ndataset.h"
#include "xmanifold.h"

NamedDataSet::NamedDataSet() : d_name_p(0), d_sid(0), d_visible(VISIBLE)
{
}

NamedDataSet::NamedDataSet(const char *name, int n, int l) :
d_name_p(new char[strlen(name) + 1]), d_sid(0), DataSet(n, l),
d_visible(VISIBLE)
{
  strcpy(d_name_p, name);
}

NamedDataSet::~NamedDataSet()
{
  delete[] d_name_p;
  if(d_sid != 0) {
    PEXDestroyStructures(Global::d_display, 1, &d_sid);
    d_sid = 0;
  }
}

void NamedDataSet::rename(const char *name)
{
  delete[] d_name_p;
  strcpy(d_name_p = new char[strlen(name) + 1], name);
}

void NamedDataSet::constructPEXStruct()
{
  int i;
  PEXCoord *pt = new PEXCoord[d_va_p -> getSize()];
  PEXColor color;

  if(d_sid != 0)
    PEXDestroyStructures(Global::d_display, 1, &d_sid);
  d_sid = PEXCreateStructure(Global::d_display);
  PEXSetViewIndex(Global::d_display, d_sid, PEXOCStore, 1);
  color.rgb = allocColor();
  PEXSetMarkerType(Global::d_display, d_sid, PEXOCStore,
		   PEXMarkerDot);
  PEXSetMarkerColor(Global::d_display, d_sid, PEXOCStore,
		    PEXColorTypeRGB, &color);
  d_min.x = d_min.y = d_min.z = MAXFLOAT;
  d_max.x = d_max.y = d_max.z = MINFLOAT;
  DataSetIter it(*this);
  for(i = 0; it; ++it, ++i) {
    translate(it(), &pt[i]);
    adjustRange(pt[i], &d_min, &d_max);
  }
  PEXMarkers(Global::d_display, d_sid, PEXOCStore, i, pt);
  delete[] pt;
}

void NamedDataSet::makeVisible()
{
  d_visible = VISIBLE;
}

void NamedDataSet::makeInvisible()
{
  d_visible = INVISIBLE;
}

const char* NamedDataSet::dataName() const
{
  return d_name_p;
}

PEXStructure NamedDataSet::getPEXStruct() const
{
  return d_sid;
}

int NamedDataSet::getVisibility() const
{
  return d_visible;
}

void NamedDataSet::getExtents(PEXCoord *min, PEXCoord *max) const
{
  *min = d_min;
  *max = d_max;
}

