// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// naming.h
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   NamingScope
//
// Notes:
//   This header includes declarations for the static class NamingScope. This
//   provides a scope for operations related to the naming convention used for
//   storing image/vector/other databases.
//   
// ----------------------------------------------------------------------------

#ifndef NAMING_INCLUDED
#define NAMING_INCLUDED

class StringAry;

class NamingScope {

  // Private Functions

  static int compare(const void*, const void*);
  // used for comparing elements in sort()

  // Public Functions

public:

  static int isValid(const char *objectName, const char *fileName,
		     const char *ending);
  // returns number of parameters in filename if the filename follows naming
  // convention AND the filename refers to a valid object refered to by
  // objectName else returns 0

  static int getNameLength(const char *fileName);
  // returns length of the "name" part of the supplied fileName

  static int getParam(const char *fileName, int i);
  // returns number in the i th parameter field of fileName

  static void sort(StringAry*);
  // sorts StringAry according to naming convention

};

#endif
