// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// mkpartialsrchtbl.C
//
// Author:               Sameer Nene
// Date:                 06/07/94
// Version:              1.0.0
// Modification History:
//   06/26/94: Change necessary because of modification of FullSearch interface
//
//
// Classes:
//
// Notes:
//   This command is used to construct a partial search method (table) for the
//   supplied data and parameters. See the man page for more details.
//   
// ----------------------------------------------------------------------------

#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "partialsearch.h"
#include "errorscope.h"
#include "parser.h"
#include "vector.h"
#include "dataset.h"
#include "ioutil.h"
#include "stringary.h"

int main(int argc, char **argv)
{
  int i, j, k, n, t, v;
  char buf[1024], *p;
  ErrorScope::Error error;
  Vector rangemin, rangemax;
  CommandParser cp(argc, argv, "v:V");
  DataSet ds;

  if((error = cp.error()) != ErrorScope::OK) {
    cerr << error << endl << "Exiting" << endl;
    exit(1);
  }
  
  StringAry &sa = cp.getObjectList();

  if((n = cp.getNumValueParams()) == 0) {
    cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
    exit (1);
  }

  if(cp.getVerboseFlag() != 0) {
    cerr << "Copyright \xA9 Columbia University, 1994. All Rights Reserved." << endl << "Sameer Nene, Shree Nayar, Hiroshi Murase" << endl << endl << "Sampling..." << endl << endl << "Constructing search table..." << endl;
  }
  
  for(i = 0, j = sa.getSize(); i < j; ++i) {
    if((error = IOUtil::get(&ds, sa[i])) != ErrorScope::OK) {
      cerr << error << ": " << sa[i] << endl << "Exiting" << endl;
      exit(1);
    }
    v = cp.getNumValues(0);
    if(n == 1)
      if(v == 2 || (v == 3 && cp.getValue(0, 0) == ds().getSize())) {
	ds.setDimension(1);
	rangemin.length(1);
	rangemax.length(1);
	ds.setSize(0, ds().getSize());
	rangemin.element(0, cp.getValue(0, 0));
	rangemax.element(0, cp.getValue(0, 1));
      }
      else {
	cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
	exit (1);
      }
    else if(v == 2 && n == ds.getSize()) {
      rangemin.length(n);
      rangemax.length(n);
      for(k = 0; k < n; ++k) {
	if(cp.getNumValues(k) != 2) {
	  cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
	  exit (1);
	}
	rangemin.element(k, cp.getValue(k, 0));
	rangemax.element(k, cp.getValue(k, 1));
      }
    }
    else if(v == 3) {
      ds.setDimension(n);
      rangemin.length(n);
      rangemax.length(n);
      for(k = 0, t = 1; k < n; ++k) {
	if(cp.getNumValues(k) != 3) {
	  cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
	  exit (1);
	}
	t *= int(v = int(cp.getValue(k, 0)));
	ds.setSize(k, int(v));
	rangemin.element(k, cp.getValue(k, 1));
	rangemax.element(k, cp.getValue(k, 2));
      }
      if(t != ds().getSize()) {
	cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
	exit (1);
      }
    }
    else {
      cerr << ErrorScope::PARAMETER_ERROR << endl << "Exiting" << endl;
      exit (1);
    }

    PartialSearch s(ds, rangemin, rangemax);

    if((p = strrchr(strcpy(buf, sa[i]), '.')) != 0)
      *p = 0;
    if((error = IOUtil::put(s, strcat(buf, ".tbl"))) != ErrorScope::OK) {
      cerr << error << ": " << buf << endl << "Exiting" << endl;
      exit(1);
    }
  }

  if(cp.getVerboseFlag() != 0)
    cerr << "Done. Exiting." << endl;

  return 0;
}
