// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// handle.h
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   Handle
//
// Notes:
//   This header includes declarations for the class Handle. Handle is used to
//   load Persistent objects from disk when their class is not known. In other
//   words a Handle can be passed to IOUtil::get() or IOUtil::put() to load in
//   a "generic" Persistent object. The object can later be safe-typecasted to
//   its real class using Persistent::safeCast().
//
// ----------------------------------------------------------------------------

#ifndef HANDLE_INCLUDED
#define HANDLE_INCLUDED

class Persistent;

class Handle {

  // Private members

  Persistent *d_persistent_p;

  // Handles cannot be assigned or copied

  Handle(const Handle&);
  Handle& operator=(const Handle&);

  // Public members

public:
  
  // Contruct and Destroy

  Handle();
  Handle(Persistent*);
  ~Handle();

  // Accessor

  Persistent* operator()() const;

  // Modifier

  void set(Persistent*);

};

#endif
