// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// fullsearch.h
//
// Author:               Sameer Nene
// Date:                 05/26/94
// Version:              1.0
// Modification History:
//   06/25/94: FullSearch is now derived directly from Persistent rather than
//             via a SearchScheme. This was necessary because SearchScheme is
//             no longer derived from a Persistent.
//   06/26/94: Change in Interface necessary due to change in interface of
//             DataSet. Internal data storage no longer as VectAry, but a
//             DataSet.
//
// Bugs:
//
// Classes:
//   FullSearch
//
// Notes:
//   This header includes declarations for the class FullSearch. This is a
//   trivial exhaustive search method and is the most CPU intensive and slow.
//   It checks the supplied point against all other points and returns the
//   closest point. FullSearch is derived from SearchScheme and hence obeys
//   that protocol. setSearchParameters() is currently not implemented. The
//   constructor FullSearch::FullSearch() is used to construct or initialize
//   the object for the supplied data. Once it is initialized, it can be
//   immediately used to do a search, or can be stored to disk for later use.
//   A mapping between the table index of the supplied data and the
//   corresponding physical quantity has also to be supplied. This ensures that
//   the vector returned by search() has the correct reverse mapping. Note
//   that FullSearch is also a Persistent, which enables load/store of
//   predefined search objects. Such objects include the entire data required
//   for a search and are fully "self sustained". A search object stored on
//   disk can be loaded in at any time to execute a search.
//   
// ----------------------------------------------------------------------------

#ifndef FULLSEARCH_INCLUDED
#define FULLSEARCH_INCLUDED

#ifndef REGISTRY_INCLUDED
#include "registry.h"
#endif

class ErrorScope;

#ifndef SEARCHSCHEME_INLCUDED
#include "searchscheme.h"
#endif

#ifndef PERSISTENT_INCLUDED
#include "persistent.h"
#endif

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

#ifndef DATASET_INCLUDED
#include "dataset.h"
#endif

#ifndef PERSISTENTSEARCHSCHEME_INCLUDED
#include "persscheme.h"
#endif

#include <stdio.h>

class FullSearch : public PersistentSearchScheme {

  // Private members
  
  static void *d_protocol;
  static char *d_name_p;
  static Registrar d_registrar;

  static Persistent* createFunc();
  // returns a pointer to a newly created FullSearch

  Vector d_rangemin, d_rangemax;
  DataSet d_data;

  // FullSearch cannot be copied or assigned

  FullSearch(const FullSearch&);
  FullSearch& operator=(const FullSearch&);

  // Protected Members
  
protected:
  
  virtual int hasProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol
  
  // Public members
  
public:
  
  // Construct and destroy

  FullSearch() {}
  
  FullSearch(const DataSet &ds, const Vector &rangemin,
	     const Vector &rangemax);
  // Construct a Full search array from points in ds. rangemin & rangemax give
  // min. & max. values of output parameters for every dimension.
  
  ~FullSearch() {}

  // Accessors

  static FullSearch* safeCast(Persistent*);
  // Converts Persistent pointer to a FullSearch pointer if the object
  // pointed to by Persistent is in fact a FullSearch
  
  Vector search(const Vector &v) const;
  // searches for v and returns result vector
  
  ErrorScope::Error put(FILE*) const;
  // puts FullSearch into file
  
  const char *name() const;
  // returns name of class

  const VectAry& getData() const;
  // returns a reference to the underlying data

  // Modifiers

  void setSearchParameters(const Vector&) {}
  // required function. Unimplemented.
  
  ErrorScope::Error get(FILE*);
  // gets FullSearch from disk
  
};

#endif

  
