// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// errorscope.h
//
// Author:               Sameer Nene
// Date:                 05/17/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   ErrorScope
//
// Notes:
//   This header includes declarations for the ErrorScope class. ErrorScope
//   forms a basis for all error reporting/handling in SLAM.
//   
// ----------------------------------------------------------------------------

#ifndef ERRORSCOPE_INCLUDED
#define ERRORSCOPE_INCLUDED

class ostream;

struct ErrorScope {

  enum Error {OK,
	      FILE_OPEN_ERROR,
	      FILE_CLOSE_ERROR,
	      INCORRECT_FORMAT,
	      FILE_READ_ERROR,
	      FILE_WRITE_ERROR,
	      DIRECTORY_OPEN_ERROR,
	      DEVICE_OPEN_ERROR,
	      DEVICE_CLOSE_ERROR,
	      DEVICE_FUNCTION_ERROR,
	      DEVICE_READ_ERROR,
	      DEVICE_WRITE_ERROR,
	      PARAMETER_ERROR };

};

ostream& operator<<(ostream&, ErrorScope::Error);

#endif
