// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// bsplinesurface.h
//
// Author:               Sameer Nene
// Date:                 05/26/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   BSplineSurface
//
// Notes:
//   This header includes declarations for the class BSplineSurface.
//   BSplineSurface is a "three dimensional" BSpline as enforced by the BSpline
//   protocol. Although the spline itself is a "surface", it can lie in
//   multidimensional space.
//
// ----------------------------------------------------------------------------

#ifndef BSPLINESURFACE_INCLUDED
#define BSPLINESURFACE_INCLUDED

#ifndef BSPLINE_INCLUDED
#include "bspline.h"
#endif

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

#ifndef REGISTRY_INCLUDED
#include "registry.h"
#endif

class Persistent;
class Interpolation;

class BSplineSurface : public BSpline {

  // Private Members

  static void* d_protocol;
  static void *d_ipProtocol;
  static char *d_name_p;
  static Registrar d_registrar;

  static Persistent* createFunc();
   // returns a pointer to a newly created BSplineSurface

  int d_sizei, d_sizej;
  Vector d_knoti, d_knotj;

  void generateBand(Vector*, int, int) const;

  // BSplineSurfaces cannot be copied or assigned

  BSplineSurface(const BSplineSurface&);
  BSplineSurface& operator=(const BSplineSurface&);

  // Protected Members
  
protected:

  int hasInterpolationProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol
  
  int hasProtocol(void* protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

  // Public Members

public:

  // Construct and Destroy
    
  BSplineSurface();
  BSplineSurface(int, int); // number of control points
  ~BSplineSurface();

  // Accessors

  static BSplineSurface* safeCast(Persistent*);
  // Converts Persistent to a BSplineSurface if the object pointed to by
  // Persistent is in fact a BSplineSurface

  static BSplineSurface* safeCast(Interpolation*);
  // Converts Interpolation to a BSplineSurface if the object pointed to by
  // Interpolation is in fact a BSplineSurface

  int getSizeI() const;
  // gets number of control points in Spline in I direction

  int getSizeJ() const;
  // gets number of control points in Spline in J direction

  Vector& getControl(int i, int j) const;
  // gets i,j th control point

  Vector sample(const Vector&) const;
  // samples the surface with supplied set of parameters and returns sampled
  // point

  int dimension() const;
  // returns dimensionality = 2

  int spaceDimension() const;

  void sample(double u, double w, Vector*) const;
  // sample Spline at parameter u, w into vector

  BSpline* clone() const;
  // makes a clone of this object

  ErrorScope::Error put(FILE*) const;
  // puts Vector in file

  const char* name() const;
  // returns the name of the class

  // Manipulators

  void setControl(int i, int j, const Vector&);
  // sets vector as i,j th control point

  ErrorScope::Error get(FILE*);
  // gets Vector from file

  void fit(const VectAry&);
  
};

#endif
