// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// bsplinecurve.h
//
// Author:               Sameer Nene
// Date:                 05/25/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   BSplineCurve
//
// Notes:
//   This header includes declarations for the class BSplineCurve. BSplineCurve
//   is a "single dimensional" BSpline as enforced by the BSpline protocol.
//   Although the spline itself is a "curve", it can lie in multidimensional
//   space.
//
// ----------------------------------------------------------------------------

#ifndef BSPLINECURVE_INCLUDED
#define BSPLINECURVE_INCLUDED

#ifndef BSPLINE_INCLUDED
#include "bspline.h"
#endif

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

#ifndef REGISTRY_INCLUDED
#include "registry.h"
#endif

class Persistent;
class Interpolation;

class BSplineCurve : public BSpline {

  // Private Members

  static void *d_protocol;
  static void *d_ipProtocol;
  static char *d_name_p;
  static Registrar d_registrar;

  static Persistent* createFunc();
   // returns a pointer to a newly created BSplineCurve

  Vector d_knot;

  // BSplineCurves cannot be copied or assigned

  BSplineCurve(const BSplineCurve&);
  BSplineCurve& operator=(const BSplineCurve&);

  // Protected Members

protected:

  int hasInterpolationProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol
  
  int hasProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

  // Public Members

public:

  // Construct and Destroy
    
  BSplineCurve();
  BSplineCurve(int); // number of control points
  ~BSplineCurve();

  // Accessors

  static BSplineCurve* safeCast(Persistent*);
  // Converts Persistent to a BSplineCurve if the object pointed to by
  // Persistent is in fact a BSplineCurve

  static BSplineCurve* safeCast(Interpolation*);
  // Converts Interpolation to a BSplineCurve if the object pointed to by
  // Interpolation is in fact a BSplineCurve

  int getSizeI() const;
  // gets number of control points in Spline in I direction

  const Vector& getControl(int i) const;
  // gets i th control point

  Vector sample(const Vector&) const;
  // samples the curve with supplied set of parameters and returns sampled
  // point

  int dimension() const;
  // returns dimensionality = 1

  int spaceDimension() const;
  // returns dimensionality of the space of the interpolation

  void sample(double t, Vector*) const;
  // sample Spline at parameter t into vector

  BSpline* clone() const;
  // makes a clone of this object

  ErrorScope::Error put(FILE*) const;
  // puts Vector in file

  const char* name() const;
  // returns the name of the class

  // Manipulators

  void setControl(int i, const Vector&);
  // sets vector as i th control point

  ErrorScope::Error get(FILE*);
  // gets Vector from file

  void fit(const VectAry&);

  void fit(const VectAry&, const Vector&);
  
};

#endif
