// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// bspline.h
//
// Author:               Sameer Nene
// Date:                 05/25/94
// Version:              1.0
// Modification History:
//   06/21/94 Changed class declaration such that the class is derived from
//            Interpolation as well as Persistent. This was necessary because
//            of the decision not to derive Interpolation from Persistent.
//
// Bugs:
//
// ToDo:
//   Change name of class from BSpline to QuadBSpline!
//
// Classes:
//   BSpline
//
// Notes:
//   This header includes declarations for the virtual base class BSpline. The
//   BSpline heirarchy is used to implement a consistent interface for various
//   bspline interpolation schemes such as curves, surfaces, etc. Since BSpline
//   itself is derived from Interpolation and Persistent, it has to follow the
//   Interpolation as well as the Persistent protocol. BSpline is actually not
//   a generic BSpline, but a special case, viz. a quadratic BSpline with a
//   special knot vector. The knot vector is set by the method formKnotVector.
//   It ensures that the curve passes through all the points.
//
// ----------------------------------------------------------------------------

#ifndef BSPLINE_INCLUDED
#define BSPLINE_INCLUDED

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

class Interpolation;
class Persistent;

#ifndef PERSISTENTINTERPOLATION_INCLUDED
#include "persinterp.h"
#endif

class BSpline : public PersistentInterpolation {

  // Private Members

  static void* d_protocol;
  static void *d_ipProtocol;

  // BSplines cannot be cpoied or assigned
  BSpline(const BSpline&);
  BSpline& operator=(const BSpline&);

  // Protected Members

protected:

  VectAry d_controlary;

  BSpline();
  BSpline(int); // number of control points

  static double basis(int i, double t, const Vector&);
  // calculate basis function value for supplied parameters

  virtual int hasProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

  virtual int hasInterpolationProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

  // Public Members

public:

  // Destructor

  virtual ~BSpline() {}

  // Utility
  
  static void formKnotVector(Vector*);
  // creates open uniform knot vector

  // Accessors

  static BSpline* safeCast(Persistent*);
  // Converts Persistent pointer to a BSpline pointer if the object pointed to
  // by Persistent is in fact a BSpline

  static BSpline* safeCast(Interpolation*);
  // Converts Interpolation to a BSpline if the object pointed to by
  // Interpolation is in fact a BSpline

  virtual BSpline* clone() const = 0;
  // This function makes the object generate an identical copy of itself and
  // returns pointer to the new copy

  // Manipulators

  virtual void fit(const VectAry&) = 0;
  // generates control points for data points passed in VectAry. Note that the
  // number of data points must exactly equal (as of yet) the number of control
  // points

};

#endif
