#!/usr/local/bin/wish -f

#
# File dialog
#
# Author: Stephen Edwards
#
# Usage:
#
# fileDialog windowPath window/IconTitle requestName OKButtonText defaultPath
#
# returns a full pathname for the selected file, or "" if cancel was selected.
#

proc fileDialog {w title text btext path} {
    global fDPathname
    set fDPathname [file dirname $path]
    global fDFilename
    set fDFilename [file tail $path]
    global fDDirectory fDDirectories fDListbox fDScrollbar
    global fDWindow

    toplevel $w -class Dialog

    wm title $w $title
    wm iconname $w $title
    wm minsize $w 10 10
    wm transient $w .

#    entry $w.e1 -textvariable fDPathname
#    entry $w.e2 -textvariable fDFilename
#    pack $w.e1 $w.e2 -side bottom -fill x

    set fDWindow $w

    # Entry along the bottom

    frame $w.en

    label $w.en.t -text $text
    entry $w.en.e -relief sunken -textvariable fDFilename

    pack $w.en.t -side top -anchor w -pady 3
    pack $w.en.e -side bottom -fill x

    pack $w.en -side bottom -fill x -padx 4 -pady 4

    # Buttons along the right side

    frame $w.b

    frame $w.b.default -relief sunken -bd 1
    button $w.b.open -text $btext -command "fDOpen"
    button $w.b.rescan -text "Rescan" -command "fDRescan"
    button $w.b.cancel -text "Cancel" -command "fDCancel"

    pack $w.b.open -in $w.b.default \
	-ipadx 3 -ipady 2 -padx 4 -pady 4 -fill x -expand 1
    pack $w.b.default -pady 10 -fill x
    pack $w.b.rescan $w.b.cancel -padx 5 -pady 10 -ipadx 3 -ipady 2 -fill x

    pack $w.b -side right -ipadx 5 -ipady 5 -padx 4

    # Listbox and pull-down

    frame $w.l

    set fDDirectory $w.l.m
    set fDDirectories $w.l.m.m
    menubutton $fDDirectory -text "fred" -relief raised -bd 2 \
	-menu $fDDirectories
    pack $fDDirectory -side top -padx 3 -pady 3
    menu $fDDirectories

    set fDListbox $w.l.f
    set fDScrollbar $w.l.s

    scrollbar $fDScrollbar -relief raised -bd 2 -command fDyview
    listbox $fDListbox -relief raised -bd 2 -setgrid yes -exportselection no \
	-yscroll "$fDScrollbar set"
    pack $fDScrollbar -side right -fill y
    pack $fDListbox -side left -fill both -expand 1

    pack $w.l -side top -fill both -expand 1 -padx 3

    # Bindings

    bind $fDListbox <Any-Button-1> "fDButton1 %y"
    bind $fDListbox <Any-B1-Motion> "fDButton1 %y"
    bind $fDListbox <Double-1> "fDOpen"

    bind $w <Return> "fDOpen"
    bind $w.en.e <Return> "fDOpen"
    bind $w.en.e <Any-Key> "$fDListbox select clear ; [bind Entry <Any-Key>]"
    bind $w.en.e <Key-Delete> "$fDListbox select clear ; [bind Entry <Key-Delete>]"
    bind $w.en.e <Control-Key-u> "$fDListbox select clear ; [bind Entry <Control-Key-u>]"
    bind $w.en.e <Control-Key-v> "$fDListbox select clear ; [bind Entry <Control-Key-v>]"
    bind $w.en.e <Left> {%W icursor [expr [%W index insert] - 1] ; \
			     tk_entrySeeCaret %W}
    bind $w.en.e <Right> {%W icursor [expr [%W index insert] + 1] ; \
			      tk_entrySeeCaret %W}
    

    #

    fDRescan

    set oldfocus [focus]

    focus $w.en.e

    tkwait visibility $w
    grab $w
    tkwait window $w

    focus $oldfocus

    if { $fDPathname != "" } {
	if { $fDPathname != "/" } {
	    return $fDPathname/$fDFilename
	} else {
	    return /$fDFilename
	}
    } else {
	return ""
    }

}

proc fDButton1 {y} {
    global fDListbox fDFilename

    set index [$fDListbox nearest $y]
    $fDListbox select from $index
    if { [string last "/" [$fDListbox get $index]] < 0 } {
	set fDFilename [$fDListbox get $index]
    }

}

proc fDOpen {} {
    global fDFilename fDPathname
    global fDListbox fDWindow

    set index [$fDListbox curselection]

    if { $index != "" } {

	# Opening something selected in the listbox

	set selection [$fDListbox get $index]
	if { [ string last "/" $selection ] >= 0 } {

	    # Opening a directory

	    set fDPathname [glob -nocomplain $fDPathname/[string trimright $selection "/"]]
	    fDRescan

	} else {

	    # Opening a file
	    #
	    # fDPathname and fDFilename are already set up correctly

	    destroy $fDWindow

	}

    } else {

	# Opening something typed in the entry

	if { [string index $fDFilename 0] == "~" || \
		 [string index $fDFilename 0] == "/" } {
	    set filename [lindex [glob -nocomplain $fDFilename] 0]
	} else {
	    set filename [lindex [glob -nocomplain $fDPathname/$fDFilename] 0]
	}
	
	if { $filename != "" && [file isdirectory $filename] } {

	    # Opening a directory

	    set fDPathname $filename
	    set fDFilename ""
	    fDRescan

	} else {

	    # Opening a file

	    destroy $fDWindow
	    
	}

    }

}

proc fDRescan {} {
    global fDPathname fDFilename fDDirectory fDDirectories fDListbox

    cd $fDPathname
    set dirname [pwd]
    set fDPathname $dirname

    # Put the names of the files in the directory in the listbox

    $fDListbox delete 0 end
    foreach f [lsort [glob -nocomplain $dirname/*]] {
	if { [file isdirectory $f] } {
	    $fDListbox insert end [file tail $f]/
	} else {
	    $fDListbox insert end [file tail $f]
	}
    }

    $fDDirectory config -text [file tail $dirname]/

    $fDDirectories delete 0 last

    while { $dirname != "/" } {
	set dirname [file dirname $dirname]
	$fDDirectories add command \
	    -label [file tail $dirname]/ \
	    -command "set fDPathname $dirname ; fDRescan"
    }
}

proc fDCancel {} {
    global fDPathname fDFilename fDWindow
    set fDPathname ""
    set fDFilename ""

    destroy $fDWindow
}

#
# "repaired" yview procedure for the listbox scrollbar:
# prevents the last item from scrolling above the last line in the listbox
#

proc fDyview {v} {
    global fDListbox fDScrollbar
    set info [$fDScrollbar get]
    set max [expr [lindex $info 0] - [lindex $info 1] ]
    $fDListbox yview [expr ($v > $max) ? $max : $v ]
}

#wm geometry . +300+10

#puts [fileDialog .file "Open" "Open drawing:" "Open" "/home/sedwards/berkeley/cs260/"]

#destroy .
