########################################
#
# View : a canvas, zoom, pan, information about what's drawn, etc.
#

itcl_class View {

    constructor { givenCanvas config } {
	set canvas $givenCanvas
	set itemObject(1) 1 ; unset itemObject(1)
	set itemData(1) 1 ; unset itemData(1)
	set attachedImages(1) 1 ; unset attachedImages(1)
	set attachedStates(1) 1 ; unset attachedStates(1)
	set attachedTransImages(1) 1 ; unset attachedTransImages(1)
	set selectedObjects(1) 1 ; unset selectedObjects(1)
    }

    destructor {
	clear
    }

    method attachImage {image state} {
#	puts "$this attachImage $image $state"
	set attachedImages($image) 1
	set attachedStates($state) $image
    }

    method detachImage {image state} {
#	puts "$this detatchImage $image $state"
	unset attachedImages($image)
	unset attachedStates($state)
	if {[info exists selectedObjects($state)]} {
	    unset selectedObjects($state)
	}
    }

    method attachTransImage {image} {set attachedTransImages($image) 1}
    method detachTransImage {image trans} {
	unset attachedTransImages($image)
	if {[info exists selectedObjects($trans)]} {
	    unset selectedObjects($trans)
	}
    }

    method clear {} {
	clearTextFocus
	foreach image [array names attachedImages] { $image delete }
	foreach image [array names attachedTransImages] { $image delete }
    }

    method config {config} {
    }

    method isSelected {object} {
	return [info exists selectedObjects($object)]
    }

    # Return true if the given state is visible in this view

    method stateIsVisible {state} {
	return [info exists attachedStates($state)]
    }

    # Create a canvas item for this view
    #
    # usage : create "polygon $x $y" $this myPolyData
    # returns the canvas item created

    method create {createBlock object {data ""}} {
	set id [eval $canvas create $createBlock]
	set itemObject($id) $object
	set itemData($id) $data
	return $id
    }

    method del {id} {
	unset itemObject($id)
	unset itemData($id)
	$canvas delete $id
    }

    method addHandle {object {data ""}} {
	global handleRad
	set id [create "rectangle 0 0 0 0 -fill black" $object $data ]
	positionHandle $id $x $y
	return $id
    }

    method positionHandle {id x y} {
	global handleRad
	$canvas coords $id [expr $x - $handleRad] [expr $y - $handleRad] \
	    [expr $x + $handleRad] [expr $y + $handleRad]
    }

#    method get {var} {return [info public $var -value]}    
    method canvasOf {} {return $canvas}
    method rootOf {} {return $root}
    method depthOf {} {return $depth}
    method xOf {} {return $x}
    method yOf {} {return $y}
    method zoomOf {} {return $zoom}
    method currentObject {} {return [objectOfID [$canvas find withtag current]]}
    method getSelected {} { return [array names selectedObjects] }

    method setTextFocus {o d i} {
	set textObject $o
	set textData $d
	set textID $i
    }
    method clearTextFocus {} {
	if { $textObject != "" } {

	    $textObject textChangeText \
		[lindex [$canvas itemconfigure $textID -text] 4 ]

	    set textObject ""
	    set textData ""
	    set textID ""

	}
	focus [focus default]
    }

    method textObjectOf {} { return $textObject }
    method textDataOf {} { return $textData }
    method textIDOf {} { return $textID }

# Select and unselect called on objects (State, Trans)

    method select {o} {
	set selectedObjects($o) 1
	$o select $this
    }

    method unselect {o} {
	unset selectedObjects($o)
	$o unselect $this
    }

    method firstSelectedState {} {
	foreach s [array names selectedObjects] {
	    if { [$s isa State] } { return $s }
	}
	return ""
    }

    method unselectAll {} {
	foreach i [ array names selectedObjects ] {
	    unselect $i
	}
    }

    method objectOfID {id} {
	if { [info exists itemObject($id)] } {
	    return $itemObject($id)
	}  else {
	    return ""
	}
    }

    method currentData {} {
	set id [$canvas find withtag current]
	if { [info exists itemData($id)] } {
	    return $itemData($id)
	} else {
	    return ""
	}
    }

    # e.g.,
    # ... findStates overlapping x1 y1 x2 y2
    # ... findStates enclosed x1 y1 x2 y2
    #
    # bottommost State is last in the returned list
    
    method findStates {args} {
	set states ""
	foreach id [eval $canvas find $args] {
	    if {[$itemObject($id) isa StateImage] && \
		    $itemData($id) == "poly"} {
		set states [linsert $states 0 [$itemObject($id) masterOf]]
	    }
	}
	return $states
    }

    method viewx {cx} {	return [expr [$canvas canvasx $cx] / double($zoom) + double($x) ] }
    method viewy {cy} {	return [expr [$canvas canvasy $cy] / double($zoom) + double($y) ] }

    method setZoom {givenZoom} {
	set zoom $givenZoom
	foreach image [array names attachedImages] { $image config }
	foreach image [array name attachedTransImages] { $image config }
	if { $viewAction != "" } { eval $viewAction }
    }

    # Draw a hierarchy

    method setView {givenRoot givenDepth givenZoom} {
	set root $givenRoot
	set zoom $givenZoom
	set depth $givenDepth
	set x [expr [$root get xw] - 10]
	set y [expr [$root get yn] - 10]
	redraw
	if { $viewAction != "" } { eval $viewAction }
    }

    method redraw {} {
	clear
	set parent \
	    [StateImage \#auto $root $this]
	drawHier $parent $depth
    }

    proc redrawall {} {
	foreach view [itcl_info object -class View] { $view redraw }
    }

    # parent is a StateImage, d the depth

    method drawHier {parent d} {
	if {$d > 0 } {
	    incr d -1
	    foreach child [[$parent masterOf] childrenOf] {
		set childImage [StateImage \#auto $child $this]
		drawHier $childImage $d
	    }
	    foreach child [[$parent masterOf] childrenOf] {
		foreach trans [$child transOf] {
		    TransImage \#auto $trans $this
		}
	    }
	}
    }

    # a command to be executed whenever the view (zoom, pan, depth) changes

    public viewAction

    # the canvas used by this view
    protected canvas

    # the object that has text focus
    protected textObject	{}
    protected textData		{}
    protected textID		{}

    # array of objects (StateImages,...) referenced by canvas item
    protected itemObject

    # array of object-specific data referenced by canvas item
    protected itemData

    # array of StateImage names in this view
    protected attachedImages

    # array of State names in this view (their StateImages)
    protected attachedStates

    # array of TransImage names in this view
    protected attachedTransImages

    # array of selected objects in this view
    protected selectedObjects


    # topmost State displayed in this view
    protected root {}

    # depth of states displayed
    protected depth {0}

    # display attributes
    protected zoom	{1.0}

    # upper-left hand corner
    protected x	{0}
    protected y	{0}

} 
