##############################
#
# Physical (canvas drawing) transtition database entries
#

itcl_class TransImage {

    # givenMaster is a Trans
    # givenView is a View

    constructor { givenMaster givenView config } {
	set master $givenMaster ; $master attachImage $this
	set view $givenView ; $view attachTransImage $this

	set arcID [$view create "line 0 0 10 10 -smooth 1 -arrow last" $this arc]
	set labelID [$view create "text 0 0" $this label]

	if [ $view isSelected $master ] { select }

	config
    }

    destructor {
	unselect
	$view del $arcID ; $view del $labelID
	$master detachImage $this ; $view detachTransImage $this $master
    }

    method viewOf {} { return $view }
    method masterOf {} { return $master }

    method config {config} {
	set c [$view canvasOf]
	set zoom [$view zoomOf]
	set vx [$view xOf]
	set vy [$view yOf]

	set lx0 [expr ([$master get x0] - $vx) * $zoom]
	set ly0 [expr ([$master get y0] - $vy) * $zoom]
	set lx1 [expr ([$master get x1] - $vx) * $zoom]
	set ly1 [expr ([$master get y1] - $vy) * $zoom]
	set lx2 [expr ([$master get x2] - $vx) * $zoom]
	set ly2 [expr ([$master get y2] - $vy) * $zoom]
	set lx3 [expr ([$master get x3] - $vx) * $zoom]
	set ly3 [expr ([$master get y3] - $vy) * $zoom]

	$c coords $arcID $lx0 $ly0 $lx1 $ly1 $lx2 $ly2 $lx3 $ly3

	$c itemconfig $arcID -fill [$master get arcFill]

	set lnx [expr ([$master get nameX] - $vx) * $zoom ]
	set lny [expr ([$master get nameY] - $vy) * $zoom ]

	$c coords $labelID $lnx $lny
	$c itemconfig $labelID \
	    -text [$master get label] \
	    -font [$master get labelFont] \
	    -fill [$master get labelColor]

	if { $handle0ID != "" } {
	    $view positionHandle $handle0ID $lx0 $ly0
	    $view positionHandle $handle1ID $lx1 $ly1
	    $view positionHandle $handle2ID $lx2 $ly2
	    $view positionHandle $handle3ID $lx3 $ly3
	    $view positionHandle $nameHandleID $lnx $lny
	}
    }

    # select and unselect called from Trans::select and Trans::unselect

    method select {} {
	if {$handle0ID == "" } {
	    set handle0ID [$view addHandle $this handle0]
	    set handle1ID [$view addHandle $this handle1]
	    set handle2ID [$view addHandle $this handle2]
	    set handle3ID [$view addHandle $this handle3]
	    set nameHandleID [$view addHandle $this nameHandle]
	}
	config
    }

    method unselect {} {
	if { $handle0ID != "" } {
	    $view del $handle0ID ; $view del $handle1ID
	    $view del $handle2ID ; $view del $handle3ID
	    $view del $nameHandleID 
	    set handle0ID ""
	}
    }

    method arrowB1 {x y data} {
	global lastX lastY currentData currentObject
	
	switch $data {
	    label -
	    arc {
		if {![$view isSelected $master]} {
		    $view unselectAll
		}
		$view select $master
	    }
	}
	set lastX $x
	set lastY $y
	set currentData $data
	set currentObject $this
    }

    method shiftArrowB1 {x y data} {
	global lastX lastY global currentData currentObject
	switch $data {
	    label -
	    arc {
		if [$view isSelected $master] {
		    $view unselect $master
		} else {
		    $view select $master
		}
	    }
	}
	set lastX $x
	set lastY $y
	set currentData $data
	set currentObject $this
    }

    method arrowB1motion {mx my data} {
	global lastX lastY currentData currentObject

	set x [$view viewx $mx]
	set y [$view viewy $my]

	set mast [$currentObject masterOf]
	switch $currentData {
	    handle0 { $mast config -x0 $x -y0 $y -arcSnap 0}
	    handle1 { $mast config -x1 $x -y1 $y -arcSnap 0}
	    handle2 { $mast config -x2 $x -y2 $y -arcSnap 0}
	    handle3 { $mast config -x3 $x -y3 $y -arcSnap 0}
	    label -
	    nameHandle { $mast config -nameX $x -nameY $y -arcSnap 0}
	}

    }

    method arrowDoubleB1 {mx my data} {
	TransDialog \#auto $master
    }

    method textB1 {mx my data} {

	set c [$view canvasOf]

	switch $data {
	    label {
		$c icursor $labelID @[$c canvasx $mx],[$c canvasy $my]
		focus $c
		$c focus $labelID
		$view setTextFocus $this label $labelID
	    }
	}
    }


    method textChangeText {t} {
	$master config -label $t
    }

    # master Trans for this image
    protected master

    # view in which this image appears
    protected view

    # canvas items
    protected arcID ; protected labelID

    # selection handles, if any
    protected handle0ID {} ; protected handle1ID {}
    protected handle2ID {} ; protected handle3ID {}
    protected nameHandleID {}
    
}
