##############################
#
# Editing dialog for a Trans
#

itcl_class TransDialog {

    constructor { givenTrans } {

	set w [string tolower $this]

	set trans $givenTrans

	global labText labFont arcCtrl arcSnap
	global TDcanvas TDhandleID TDlineID

	trace variable arcCtrl($w) w shapeLine

	set entries ""

	###

	toplevel .$w

	wm minsize .$w 100 100
	wm title .$w "Edit Transition"

	###

	frame .$w.bu -relief raised -bd 1
	pack .$w.bu -side bottom -fill both

	###

	frame .$w.bu.def -relief sunken -bd 1
	button .$w.bu.apply -text "Apply" -command "$this apply"
	pack .$w.bu.apply -in .$w.bu.def -side left \
	    -ipadx 2m -ipady 1m -padx 2m -pady 2m
	pack .$w.bu.def -side left -expand 1

	button .$w.bu.dismiss -text "Dismiss" -command "$this delete"
	pack .$w.bu.dismiss -side left -expand 1 \
	    -padx 3m -pady 3m -ipadx 2m -ipady 1m

	###

	frame .$w.b -relief raised -bd 1
	pack .$w.b -side bottom -fill both -expand yes

	###

	frame .$w.b.a
	pack .$w.b.a -side top -fill x

	label .$w.b.source -text [[$trans sourceOf] get name]
	label .$w.b.dest -text [[$trans destinationOf] get name]

	pack .$w.b.source -side left -anchor w -in .$w.b.a
	pack .$w.b.dest -side right -anchor e -in .$w.b.a

	###

	set c .$w.b.c

	set TDcanvas($w) $c

	canvas $c -width 200 -height 50
	pack $c -anchor center -side top -in .$w.b.a

	set TDlineID($w) [$c create line 0 0 -10 -10 -smooth 1 -arrow last]
	set TDhandleID($w) [$c create rect 0 0 -5 -5 -fill black]

	bind $c <Button-1> "$this position %y"
	bind $c <B1-Motion> "$this position %y"

	###

	set f .$w.b.label

	frame $f -relief ridge -bd 2
	pack $f -side top -fill both -padx 10 -pady 3 -ipadx 2m -ipady 2m

	label $f.lab -text "Label"
	pack $f.lab -anchor w -side top
    
	lappend entries [entry $f.ent -relief sunken -bd 2 -textvariable labText($w)]
	pack $f.ent -anchor w -side top -fill x -padx 5

	FontChooser $f.font -fontobject $f.ent
	pack $f.font -side top -fill x
	lappend entries $f.font.font

	ColorEditor $f.col -size 75 -action "$f.ent config -foreground"
	lappend entries $f.col.s.r.value.e
	$f.col install [$trans get labelColor]
	pack $f.col -side top -fill x
	
	###

	set f .$w.b.arc

	frame $f -relief ridge -bd 2
	pack $f -side bottom -fill both -padx 10 -pady 3

	label $f.lab -text "Arc"
	pack $f.lab -anchor w -side top

	frame $f.fb
	radiobutton $f.fb.fixedbut -text "fixed curvature" \
	    -variable arcSnap($w) -value 1 -relief flat
	radiobutton $f.freeformbut -text "free form" \
	    -variable arcSnap($w) -value 0 -relief flat

	lappend entries [entry $f.fb.fixedent -relief sunken -bd 2 -textvariable arcCtrl($w)]
	pack $f.fb.fixedbut -side left
	pack $f.fb.fixedent -side left -expand 1
	pack $f.fb $f.freeformbut -side top -anchor w

	ColorEditor $f.col -size 75 -action "$c itemconfig $TDlineID($w) -fill"
	lappend entries $f.col.s.r.value.e
	$f.col install [$trans get arcFill]

	pack $f.col -side top -fill x

	###

	foreach entry $entries {
	    bind $entry <Return> ".$w.bu.apply flash ; $this apply"
	}

	for { set i [expr [llength $entries] - 1] } { [incr i -1] >= 0 } {} {
	    set nextentry [lindex $entries [expr $i + 1] ]
	    bind [lindex $entries $i] <Tab> "focus $nextentry"
	    bind [lindex $entries $i] <Down> "focus $nextentry"
	}
	for { set i [llength $entries] } { [incr i -1] > 0 } {} {
	    set lastentry [lindex $entries [expr $i - 1] ]
	    bind [lindex $entries $i] <Up> "focus $lastentry"
	}
	set lastentry [lindex $entries [expr [llength $entries] - 1]]
	set firstentry [lindex $entries 0]
	bind $lastentry <Tab> "focus $firstentry"
	bind $lastentry <Down> "focus $firstentry"
	bind $firstentry <Up> "focus $lastentry"

	###

	set labText($w) [$trans get label]
	set labFont($w) [$trans get labelFont]
	set arcCtrl($w) [$trans get arcCtrl]
	set arcSnap($w) [$trans get arcSnap]

    }

    destructor {

	global labText labFont arcCtrl arcSnap
	global TDcanvas TDhandleID TDlineID

	destroy .$w

	unset labText($w)
	unset labFont($w)
	unset arcCtrl($w)
	unset arcSnap($w)

	unset TDcanvas($w)
	unset TDhandleID($w)
	unset TDlineID($w)

    }

    method position {y} {
	global arcCtrl arcSnap

	set y [$c canvasy $y]
	set arcCtrl($w) [expr (25 - $y)/200.0]
	set arcSnap($w) 1
    }

    method apply {} {
	global labText labFont arcCtrl arcSnap

	$trans config \
	    -label $labText($w) \
	    -labelColor [.$w.b.label.col get] \
	    -labelFont [.$w.b.label.font get ] \
	    -arcCtrl $arcCtrl($w) \
	    -arcSnap $arcSnap($w) \
	    -arcFill [.$w.b.arc.col get]

	.$w.b.label.font setfont
	.$w.b.label.col install [.$w.b.label.col get]
	.$w.b.arc.col install [.$w.b.arc.col get]
    }

    # toplevel window we're using
    protected w

    # canvas

    protected c

    # transition being edited
    protected trans

}

proc shapeLine {name element op} {
    global TDcanvas TDlineID TDhandleID arcCtrl 
    set y [expr 25 - 200 * $arcCtrl($element)]
    $TDcanvas($element) coords $TDlineID($element) 0 25 100 $y 200 25
    $TDcanvas($element) coords $TDhandleID($element) 97 [expr $y - 3] 103 [expr $y+3]
}

