##############################
#
# Logical transition database entries
#

itcl_class Trans {

    constructor { givenSource givenDestination config } {
	set source $givenSource
	set destination $givenDestination

	if { $arcCtrl == "" } {

	    # Find the transition on the source state with the largest
	    # arcCtrl and go just a little larger
	    
	    set arcCtrl 0
	    
	    foreach t [$givenSource transOf] {
		set ac [$t get arcCtrl]
		if { $ac > $arcCtrl } { set arcCtrl $ac }
	    }
	    set arcCtrl [expr $arcCtrl + 0.1]
	}

	$source attachTrans $this
	$destination attachTransD $this

	set attachedImages(1) 1 ; unset attachedImages(1)

	if {$arcSnap} {snapArc}
	config
    }

    destructor {
	foreach i [array names attachedImages] { $i delete }
	$source detachTrans $this
	$destination detachTransD $this
    }

    method config {config} {
	if {$arcSnap} { snapArc } else {
	    if {$sourcedirty} {fixSource ; set sourcedirty 0}
	    if {$destinationdirty} {fixDestination ; set destinationdirty 0}
	}
	foreach image [array names attachedImages] { $image config }
    }

    method recreate {} {
	set s "Trans {$this} {$source} {$destination}"
	foreach pvar "label labelColor labelFont arcFill arcCtrl arcSnap" {
	    set val [$this info public $pvar -value]
	    set init [$this info public $pvar -init]
	    if { $val != $init } { append s " -$pvar {$val}" }
	}
	if { [$this info public arcSnap -value] == 0 } {
	    foreach pvar "x0 y0 x1 y1 x2 y2 x3 y3 nameX nameY" {
		append s " -$pvar {[$this info public $pvar -value]}"
	    }
	}
	return $s
    }

    method fixSource {} {
	set xe [$source get xe]
	set xw [$source get xw]
	set yn [$source get yn]
	set ys [$source get ys]

	if {$x0 < $xw} {set x0 $xw}
	if {$x0 > $xe} {set x0 $xe}
	if {$y0 < $yn} {set y0 $yn}
	if {$y0 > $ys} {set y0 $ys}
    }

    method fixDestination {} {
	set xe [$destination get xe]
	set xw [$destination get xw]
	set yn [$destination get yn]
	set ys [$destination get ys]

	if {$x3 < $xw} {set x3 $xw}
	if {$x3 > $xe} {set x3 $xe}
	if {$y3 < $yn} {set y3 $yn}
	if {$y3 > $ys} {set y3 $ys}
    }

    method moves {dx dy} {
	if {$arcSnap} {snapArc} else {
	    set x0 [expr $x0 + $dx] ; set y0 [expr $y0 + $dy]
	    set x1 [expr $x1 + $dx * 0.75 ] ; set y1 [expr $y1 + $dy * 0.75]
	    set x2 [expr $x2 + $dx * 0.25 ] ; set y2 [expr $y2 + $dy * 0.25]
	    set nameX [expr $nameX + $dx / 2.0]
	    set nameY [expr $nameY + $dy / 2.0]
	}
    }

    method moved {dx dy} {
	if {$arcSnap} {snapArc} else {
	    set x1 [expr $x1 + $dx * 0.25] ; set y1 [expr $y1 + $dy * 0.25]
	    set x2 [expr $x2 + $dx * 0.75] ; set y2 [expr $y2 + $dy * 0.75]
	    set x3 [expr $x3 + $dx] ; set y3 [expr $y3 + $dy]
	    set nameX [expr $nameX + $dx / 2.0]
	    set nameY [expr $nameY + $dy / 2.0]
	}
    }

    method attachImage {image} {set attachedImages($image) 1}
    method detachImage {image} {unset attachedImages($image)}

    method get {var} {return [info public $var -value]}
    method sourceOf {} {return $source}
    method destinationOf {} {return $destination}

    method select {view} {
	foreach image [array names attachedImages] {
	    if { $view == [$image viewOf] } {
		$image select
	    }
	}
    }

    method unselect {view} {
	foreach image [array names attachedImages] {
	    if { $view == [$image viewOf] } {
		$image unselect
	    }
	}
    }


    # Make the arc linear between the centers of its two states

    method snapArc {} {

	set ss $source
	set ds $destination

	set rxs [expr ([$ss get xe] - [$ss get xw]) / 2.0 ]
	set rys [expr ([$ss get ys] - [$ss get yn]) / 2.0 ]

	set cxs [expr ([$ss get xe] + [$ss get xw]) / 2.0 ]
	set cys [expr ([$ss get ys] + [$ss get yn]) / 2.0 ]

	if { $ss != $ds } {

	    # Not a self-arc

	    set rxd [expr ([$ds get xe] - [$ds get xw]) / 2.0 ]
	    set ryd [expr ([$ds get ys] - [$ds get yn]) / 2.0 ]
	    set cxd [expr ([$ds get xe] + [$ds get xw]) / 2.0 ]
	    set cyd [expr ([$ds get ys] + [$ds get yn]) / 2.0 ]

	    set dx [expr $cxd - $cxs]
	    set dy [expr $cyd - $cys]

	    set cx [expr ($cxs + $cxd) * 0.5 + $arcCtrl * $dy]
	    set cy [expr ($cys + $cyd) * 0.5 - $arcCtrl * $dx]

	    set dx1 [expr $cx - $cxs]
	    set dy1 [expr $cy - $cys]

	    set dx2 [expr $cx - $cxd]
	    set dy2 [expr $cy - $cyd]

	    if { abs($dy1) * $rxs < abs($dx1) * $rys } {
		if {$dx1 > 0} { set x0 [$ss get xe] } else { set x0 [$ss get xw] }
		set y0 [expr $cys + $dy1 * $rxs / abs($dx1)]
	    } else {
		set x0 [expr $cxs + $dx1 * $rys / abs($dy1)]
		if {$dy1 > 0} { set y0 [$ss get ys] } else { set y0 [$ss get yn] }
	    }

	    if { abs($dy2) * $rxd < abs($dx2) * $ryd } {
		if {$dx2 > 0} { set x3 [$ds get xe] } else { set x3 [$ds get xw] }
		set y3 [expr $cyd + $dy2 * $rxd / abs($dx2)]
	    } else {
		set x3 [expr $cxd + $dx2 * $ryd / abs($dy2)]
		if {$dy2 > 0} { set y3 [$ds get ys] } else { set y3 [$ds get yn] }
	    }

	    set dx [expr $x3 - $x0]
	    set dy [expr $y3 - $y0]

	    set x1 [expr (3*$x0 + $x3) * 0.25 + $arcCtrl * $dy ]
	    set y1 [expr (3*$y0 + $y3) * 0.25 - $arcCtrl * $dx ]

	    set x2 [expr ($x0 + 3*$x3) * 0.25 + $arcCtrl * $dy ]
	    set y2 [expr ($y0 + 3*$y3) * 0.25 - $arcCtrl * $dx ]

	} else {

	    # A self-arc

	    set r [expr $rys * $arcCtrl]
	    set y0 [expr $cys - $r]
	    set y1 $y0
	    set y2 [expr $cys + $r]
	    set y3 $y2
	    
	    if { $arcCtrl >= 0 } {
		set x0 [$ss get xe]
	    } else {
		set x0 [$ss get xw]
	    }

	    set x1 [expr $x0 + $r * 2]
	    set x2 $x1
	    set x3 $x0
	    
	}

	set nameX [expr ($x1 + $x2) / 2.0 ]
	set nameY [expr ($y1 + $y2) / 2.0 ]

    }

    protected sourcedirty {0}
    protected destinationdirty {0}

    # source and destination states for this transition
    protected source
    protected destination

    # label information
    public label	{}

    public labelColor		{black}
    public labelFont		{-*-helvetica-medium-r-normal--*-100-*}

    # arc information
    public arcFill		{black}
    public arcCtrl		{}
    public arcSnap		{1}

    # coordinates of the four arc control points (unscaled)

    public x0 {} {set sourcedirty 1}
    public y0 {} {set sourcedirty 1}

    public x1 {} ; public y1 {}
    public x2 {} ; public y2 {}

    public x3 {} {set destinationdirty 1}
    public y3 {} {set destinationdirty 1}

    # coordinates of the name

    public nameX {} ; public nameY {}

    # attached TransImages
    protected attachedImages

}
