########################################
#
# Physical (canvas drawing) state database entries
#

set arcKludge 0.588

itcl_class StateImage {

    # givenMaster is a State
    # givenView is a View

    constructor { givenMaster givenView config } {
	set master $givenMaster ; $master attachImage $this
	set view $givenView 	; $view attachImage $this $master

	set polyID [$view create "polygon 0 0 10 10 0 0 -smooth 1" $this poly]
	set lineID [$view create "line 0 0 10 10 -smooth 1" $this line]
	set nameID [$view create "text 0 0 -anchor w" $this name]

	# puts "Creating $master as $this:[$view isSelected $master]"

	if [$view isSelected $master] { select }

	config
    }

    destructor {
	unselect
	$view del $polyID ; $view del $lineID ; $view del $nameID
	$master detachImage $this ; $view detachImage $this $master
    }

    method get {var} {return [info public $var -value]}
    method masterOf {} {return $master}
    method viewOf {} {return $view}

    method config { config } {
	global arcKludge

	set xpan [$view xOf]
	set ypan [$view yOf]
	set zoom [$view zoomOf]
	set c [$view canvasOf]

	set xw [expr ([$master get xw] - $xpan) * $zoom ]
	set xe [expr ([$master get xe] - $xpan) * $zoom ]
	set yn [expr ([$master get yn] - $ypan) * $zoom ]
	set ys [expr ([$master get ys] - $ypan) * $zoom ]

	set incX [expr ($xe - $xw) * [$master get ctrlRelX] ]
	set incY [expr ($ys - $yn) * [$master get ctrlRelY] ]

	set xw1 [expr $xw + $incX]
	set xe1 [expr $xe - $incX]
	set yn1 [expr $yn + $incY]
	set ys1 [expr $ys - $incY]

	$c coords $lineID \
	    $xw1 $yn $xe1 $yn $xe1 $yn \
	    [expr $xe - $incX * $arcKludge] $yn \
	    $xe [expr $yn + $incY * $arcKludge] \
	    $xe $yn1 $xe $yn1 $xe $ys1 $xe $ys1 \
	    $xe [expr $ys - $incY * $arcKludge] \
	    [expr $xe - $incX * $arcKludge] $ys \
	    $xe1 $ys $xe1 $ys $xw1 $ys $xw1 $ys \
	    [expr $xw + $incX * $arcKludge] $ys \
	    $xw [expr $ys - $incY * $arcKludge] \
	    $xw $ys1 $xw $ys1 $xw $yn1 $xw $yn1 \
	    $xw [expr $yn + $incY * $arcKludge] \
	    [expr $xw + $incX * $arcKludge] $yn \
	    $xw1 $yn

	eval $c coords $polyID [$c coords $lineID]

	set stipple [$master get boxStipple]
	if { $stipple != "none" } {$c itemconfig $lineID -stipple $stipple} \
	    else {$c itemconfig $lineID -stipple ""}
	$c itemconfig $polyID -fill [$master get boxFill]
	$c coords $nameID [expr ([$master get nameX] - $xpan) * $zoom] \
	    [expr ([$master get nameY] - $ypan) * $zoom]
	$c itemconfig $nameID -text [$master get name] \
	    -font [$master get nameFont] -fill [$master get nameColor]

	if { $NWhandleID != "" } {
	    $view positionHandle $NWhandleID $xw $yn
	    $view positionHandle $SWhandleID $xw $ys
	    $view positionHandle $NEhandleID $xe $yn
	    $view positionHandle $SEhandleID $xe $ys
	    eval $view positionHandle $nameHandleID [$c coords $nameID]
	    $view positionHandle $ctrlHandleID $xw1 $yn1
	}
    }

    method raise {} {
	set c [$view canvasOf]
	$c raise $polyID
	$c raise $lineID
	$c raise $nameID
    }

    # select and unselect called from State::select, State::unselect

    method select {} {
	if { $NWhandleID == "" } {
	    set NWhandleID [$view addHandle $this NWhandle]
	    set SWhandleID [$view addHandle $this SWhandle]
	    set NEhandleID [$view addHandle $this NEhandle]
	    set SEhandleID [$view addHandle $this SEhandle]
	    set nameHandleID [$view addHandle $this nameHandle]
	    set ctrlHandleID [$view addHandle $this ctrlHandle]
	}
	config
    }

    method unselect {} {
	if { $NWhandleID != "" } {
	    $view del $NWhandleID
	    $view del $SWhandleID
	    $view del $NEhandleID
	    $view del $SEhandleID
	    $view del $nameHandleID
	    $view del $ctrlHandleID
	    set NWhandleID ""
	}
    }

    method arrowB1 {x y data} {
	global lastX lastY currentData currentObject

#	puts "$this called with $x $y $data"
	switch $data {
	    name -
	    line {
		if {![$view isSelected $master]} {
		    $view unselectAll
		}
		$view select $master
	    }
	    poly { $view unselectAll }
	}
	set lastX $x
	set lastY $y
	set currentData $data
	set currentObject $this
    }

    method shiftArrowB1 {x y data} {
	global lastX lastY global currentData currentObject
	switch $data {
	    name -
	    line {
		if [$view isSelected $master] {
		    $view unselect $master
		} else {
		    $view select $master
		}
	    }
	}
	set lastX $x
	set lastY $y
	set currentData $data
	set currentObject $this
    }
   
    method arrowB1motion {mx my data} {
	global lastX lastY
	global currentData
	global currentObject

	set x [$view viewx $mx]
	set y [$view viewy $my]
	set mast [$currentObject masterOf]

	switch $currentData {
	    NWhandle { $mast config -xw $x -yn $y }
	    SWhandle { $mast config -xw $x -ys $y }
	    NEhandle { $mast config -xe $x -yn $y }
	    SEhandle { $mast config -xe $x -ys $y }

	    line {
		foreach object [$view getSelected] {
		    set zoom [$view zoomOf]
		    set dx [expr ($mx - $lastX) / double($zoom) ]
		    set dy [expr ($my - $lastY) / double($zoom) ]
		    if [$object isa State] {
			$object move $dx $dy
		    }
		}		
	    }

	    name -
	    nameHandle {
		$mast config -nameX [$view viewx $mx] \
		    -nameY [$view viewy $my]
	    }

	    ctrlHandle {
		set width [expr double([$mast get xe] - [$master get xw])]
		set height [expr double([$mast get ys] - [$master get yn])]
		set ctrlRelX [expr double($x - [$mast get xw])/$width]
		set ctrlRelY [expr double($y - [$mast get yn])/$height]
		if { $ctrlRelX < 0 } { set ctrlRelX 0 }
		if { $ctrlRelX > 0.5} { set ctrlRelX 0.5 }
		if { $ctrlRelY < 0 } { set ctrlRelY 0 }
		if { $ctrlRelY > 0.5} { set ctrlRelY 0.5 }
		$mast config -ctrlRelX $ctrlRelX -ctrlRelY $ctrlRelY
	    }

	}

	set lastX $mx
	set lastY $my
    }
    
    method arrowB1release {x y data} {
	global currentData
	global currentObject
	set mast [$currentObject masterOf]

	set c [$view canvasOf]
	set x [$c canvasx $x]
	set y [$c canvasy $y]

	switch $currentData {

	    # Check to see if the moved states have been placed in
	    # a different parent

	    line {
		set parents [$view findStates overlapping $x $y $x $y]
		set parent [lindex $parents 0]
		if {$parent == $mast} {
		    set parent [lindex $parents 1]
		}
		if {$parent != "" && $parent != [$mast parentOf]} {
		    puts "Moving into $parent"
		    foreach object [$view getSelected] {
			if {[$object isa State] && ($object != $parent) } {
			    $object changeParent $parent
			}			    
		    }
		}

	    }
	}
    }

    method arrowDoubleB1 {mx my data} {
	StateDialog \#auto $master
    }


    method textB1 {mx my data} {

	set c [$view canvasOf]

	switch $data {
	    name {
		$c icursor $nameID @[$c canvasx $mx],[$c canvasy $my]
		focus $c
		$c focus $nameID
		$view setTextFocus $this name $nameID
	    }
	}
    }

    method textChangeText {t} {
	$master config -name $t
    }

    # master State for this image
    protected master

    # view in which this image appears
    protected view

    # canvas item
    protected polyID ; protected lineID ; protected nameID

    # selection handles, if any
    protected NWhandleID {} ; protected NEhandleID {}
    protected SWhandleID {} ; protected SEhandleID {}
    protected nameHandleID {} ; protected ctrlHandleID {}

    # actual position information
    public x; public y; public width; public height
}

