########################################
#
# Editing dialog for a State
#

itcl_class StateDialog {

    constructor { givenState } {

	global nameText boxStipple

	set entries ""

	set w [string tolower $this]

	set state $givenState

	toplevel .$w

	wm minsize .$w 100 100
	wm title .$w "Edit State"

	### The two frames:  body and buttons

	frame .$w.b -relief raised -bd 1
	frame .$w.bu -relief raised -bd 1

	pack .$w.b .$w.bu -side top -fill both

	### The buttons

	frame .$w.bu.def -relief sunken -bd 1
	button .$w.bu.apply -text "Apply" -command "$this apply"
	pack .$w.bu.apply -in .$w.bu.def -side left \
	    -ipadx 2m -ipady 1m -padx 2m -pady 2m
	pack .$w.bu.def -side left -expand 1

	button .$w.bu.dismiss -text "Dismiss" -command "$this delete"
	pack .$w.bu.dismiss -side left -expand 1 \
	    -padx 3m -pady 3m -ipadx 2m -ipady 1m

	### The state name frame

	set f .$w.b.name

	frame $f -relief ridge -bd 2
	pack $f -side top -fill both -padx 10 -pady 3

	label $f.lab -text "Name"
	pack $f.lab -anchor w -side top

	lappend entries [entry $f.ent -relief sunken -bd 2 -textvariable nameText($w)]
	pack $f.ent -anchor w -side top -fill x -padx 5

	FontChooser $f.font -fontobject $f.ent
	pack $f.font -side top -fill x
	lappend entries $f.font.font

	ColorEditor $f.col -size 75 -action "$f.ent config -foreground"
	lappend entries $f.col.s.r.value.e
	pack $f.col -side top -fill x

	### The box frame

	set f .$w.b.box

	frame $f -relief ridge -bd 2
	pack $f -side top -fill both -padx 10 -pady 3

	label $f.lab -text "Box Fill"
	pack $f.lab -anchor w -side top

	ColorEditor $f.col -size 75
	lappend entries $f.col.s.r.value.e
	pack $f.col -side top -fill x

	### The outline frame

	set f .$w.b.outline

	frame $f -relief ridge -bd 2
	pack $f -side top -fill both -padx 10 -pady 3

	label $f.lab -text "Outline Stipple"
	pack $f.lab -anchor w -side top

	radiobutton $f.none -text "Solid" -variable boxStipple($w) \
	    -relief flat -value "none"
	radiobutton $f.gray50 -bitmap gray50 -variable boxStipple($w) \
	    -relief flat -value gray50
	radiobutton $f.gray25 -bitmap gray25 -variable boxStipple($w) \
	    -relief flat -value gray25

	pack $f.none $f.gray50 $f.gray25 -side left

	### Set up the bindings for the entries

	foreach entry $entries {
	    bind $entry <Return> ".$w.bu.apply flash ; $this apply"
	}

	for { set i [expr [llength $entries] - 1] } { [incr i -1] >= 0 } {} {
	    set nextentry [lindex $entries [expr $i + 1] ]
	    bind [lindex $entries $i] <Tab> "focus $nextentry"
	    bind [lindex $entries $i] <Down> "focus $nextentry"
	}
	for { set i [llength $entries] } { [incr i -1] > 0 } {} {
	    set lastentry [lindex $entries [expr $i - 1] ]
	    bind [lindex $entries $i] <Up> "focus $lastentry"
	}
	set lastentry [lindex $entries [expr [llength $entries] - 1]]
	set firstentry [lindex $entries 0]
	bind $lastentry <Tab> "focus $firstentry"
	bind $lastentry <Down> "focus $firstentry"
	bind $firstentry <Up> "focus $lastentry"

	###

	update
	set nameText($w) [$state get name]
	set boxStipple($w) [$state get boxStipple]
	
	.$w.b.name.col install [$state get nameColor]
	.$w.b.box.col install [$state get boxFill]
    }

    destructor {

	global nameText boxStipple

	destroy .$w

	unset nameText($w)
	unset boxStipple($w)

    }

    method apply {} {
	global nameText boxStipple

	$state config \
	    -name $nameText($w) \
	    -nameColor [.$w.b.name.col get] \
	    -nameFont [.$w.b.name.font get] \
	    -boxFill [.$w.b.box.col get] \
	    -boxStipple $boxStipple($w)

	.$w.b.name.font setfont
	.$w.b.name.col install [.$w.b.name.col get]
	.$w.b.box.col install [.$w.b.box.col get]
    }

    # The state being edited

    protected state

    # toplevel window we're using

    protected w

}
