########################################
#
# Logical state database entries
#

itcl_class State {

    constructor { {givenParent ""} config } {

	if { $name == "" } {
	    set name S$nextState
	    incr nextState
	}

	set parent $givenParent

	if { $parent != "" } {
	    $parent attachChild $this
	} else {
	    set rootState $this
	}

	set children(1) 1 ; unset children(1)
	set attachedImages(1) 1 ; unset attachedImages(1)
	set attachedTrans(1) 1 ; unset attachedTrans(1)
	set attachedTransD(1) 1 ; unset attachedTransD(1)

	config
    }

    destructor {

	foreach c [array names children] {
	    $c delete
	}

	foreach i [array names attachedImages] {
	    $i delete
	}

	foreach t [array names attachedTrans] {
	    $t delete
	}

	foreach t [array names attachedTransD] {
	    $t delete
	}

	if { $parent != "" } {
	    $parent detachChild $this
	}


    }

    proc restart {} {
	set nextState 0
    }

    method changeParent {givenParent} {
	$parent detachChild $this
	set parent $givenParent
	$parent attachChild $this
	config
	foreach image [array names attachedImages] { $image raise }
    }

    method config {config} {
	foreach image [array names attachedImages] { $image config }
	foreach image [array names attachedTrans] { $image config }
	foreach image [array names attachedTransD] { $image config }
    }

    method get {var} {return [info public $var -value]}
    method parentOf {} { return $parent }
    method childrenOf {} { return [array names children] }
    method transOf {} { return [array names attachedTrans] }

    method attachChild {child} {set children($child) 1}
    method detachChild {child} {unset children($child)}

    method attachImage {image} {set attachedImages($image) 1}
    method detachImage {image} {unset attachedImages($image)}

    method attachTrans {trans} {set attachedTrans($trans) 1}
    method detachTrans {trans} {unset attachedTrans($trans)}

    method attachTransD {trans} {set attachedTransD($trans) 1}
    method detachTransD {trans} {unset attachedTransD($trans)}

    proc rootStateOf {} { return $rootState }

    method recreate {} {
	set s "State {$this} {$parent}"
	foreach pvar [$this info public] {
	    regsub "State::" $pvar "" pvar
	    set val [$this info public $pvar -value]
	    set init [$this info public $pvar -init]
	    if { $val != $init } {append s " -$pvar {$val}"}
	}
	return $s
    }

    method select {view} {
	foreach image [array names attachedImages] {
	    if { $view == [$image viewOf] } {
		$image select
	    }
	}
    }

    method unselect {view} {
	foreach image [array names attachedImages] {
	    if { $view == [$image viewOf] } {
		$image unselect
	    }
	}
    }

    method move {dx dy} {
	set yn [expr $yn + $dy]
	set ys [expr $ys + $dy]
	set xe [expr $xe + $dx]
	set xw [expr $xw + $dx]
	set nameX [expr $nameX + $dx]
	set nameY [expr $nameY + $dy]
	foreach child [array names children] { $child move $dx $dy }
	foreach trans [array names attachedTrans] { $trans moves $dx $dy }
	foreach trans [array names attachedTransD] { $trans moved $dx $dy }
	config
    }

    # class-specific variable used to assign sequential state names
    common nextState	{0}

    # class-specific variable recalling which state is the topmost
    common rootState	{}

    # Name of this state
    public name		{}

    # parent State
    protected parent	{}

    # array of child States
    protected children

    # Bounding box for this State
    public xw		{10}
    public yn		{10}
    public xe		{300}
    public ys		{300}

    # relative position of corner arc control points:
    #  ctrlRelX = ctrlRelY = 0 is a box
    #  ctrlRelX = ctrlRelY = 0.5 is a circle/ellipse
    #  in between gives rounded rectangles
    public ctrlRelX	{0.1}
    public ctrlRelY	{0.1}

    # position of the state's name
    public nameX	{30}
    public nameY	{30}

    # color and font to use when displaying the state's name
    public nameColor	{black}
    public nameFont	{-*-helvetica-medium-r-normal--*-120-*}

    # stipple pattern to use for the outline
    public boxStipple	{none}

    # fill color for the interior
    public boxFill	{lightgray}

    # attached StateImages
    protected attachedImages

    # attached Trans (we are source)
    protected attachedTrans

    # attached Trans (we are destination)
    protected attachedTransD

}
