##############################
#
# Help system
#

itcl_class Help {

    constructor {} {

	set w .[string tolower $this]

	toplevel $w
	wm minsize $w 50 50

	button $w.dismiss -text "Dismiss" \
	    -command "$this delete"
	pack $w.dismiss -side bottom -ipadx 4 -ipady 2 -padx 4 -pady 4

	set te $w.t

	text $te -relief raised -bd 2 -yscrollcommand "$w.s set" \
	    -wrap word -cursor ""
	scrollbar $w.s -command "$te yview"
	pack $w.s -side right -fill y
	pack $te -side top -expand 1 -fill both

	$te tag configure normal -font -*-times-medium-r-normal-*-*-140-*
        $te tag configure italic -font -*-times-medium-i-normal-*-*-140-*
        $te tag configure bold -font -*-times-bold-r-normal-*-*-140-*
	$te tag configure bigbold -font -*-times-bold-r-normal-*-*-240-*
	$te tag configure medbold -font -*-times-bold-r-normal-*-*-180-*
        $te tag configure courier -font -*-courier-medium-r-normal-*-*-140-*
	$te tag configure button \
            -font [lindex [$w.dismiss configure -font] 4] \
            -relief raised -borderwidth 1 -background #eed5b7
     
    }


    destructor {

	destroy $w

    }

    method t {tags text} {
	set start [$te index insert]
	$te insert insert $text
	foreach tag [$te tag names $start] {
	    $te tag remove $tag $start insert
	}
	foreach tag $tags {
	    $te tag add $tag $start insert
	}
    }


    protected w
    protected te

}

itcl_class HelpAbout {

    inherit Help

    constructor {} {

	Help::constructor

	wm title $w "About..."
	wm iconname $w "About...

	t bigbold "Statecharts\n"

	t normal "\nA drawing program by "
	t italic "Stephen Edwards"
	t normal " for "
	t italic " CS 260.\n\n"

	t bold "Statecharts"
	t normal " manipulates hierarchically-arranged states with connected transitions.\n\n"

	t normal "A "
	t bold "state"
	t normal " is a named box drawn as a circle, a rounded rectangle, or a square.  States are created by dragging out their outlines with the "
	t italic "state"
	t normal " tool, the second from the top, immediately below the arrow.\n\n"

	t normal "A "
	t bold "transition"
	t normal " is a named, curving arrow connecting two states.  Create a transition by dragging an arrow between the interiors of two states with the "
	t italic "transition"
	t normal " tool, the third from the top, immediately below the state tool.\n\n"

    }

}

itcl_class HelpEditing {

    inherit Help

    constructor {} {

	Help::constructor

	wm title $w "Help on Editing"
	wm iconname $w "Help on Editing"

	t bigbold "Editing"
	t normal "\n\n"

	t medbold "Buttons\n\n"

	t normal "One statechart is edited at any time.  Press the "
	t button " New "
	t normal " button to start a new one.  Press the "
	t button " Open "
	t normal " button to load a previously-saved one.  Press the "
	t button " Save "
	t normal " button to save the current one.  Press the the "
	t button " Save As "
	t normal " button to save the current one under a different name.\n\n"

	t normal "The "
	t button " New View "
	t normal " button opens a new window on the current statechart.\n\n"

	t normal "The "
	t button " Quit "
	t normal " button exits the program.\n\n"

	t medbold "Tools\n\n"

	t normal "Press one of the top four buttons along the left-hand side of the editing window to select a "
	t bold "tool"
	t normal ".  The current one is highlighted in pink.\n\n"

	t normal "The tools, from the top left, are\n"
	t bold " the arrow tool"
	t normal " to select, change, and move objects\n"
	t bold " the state tool"
	t normal " to create states\n"
	t bold " the transition tool"
	t normal " to create transitions\n"
	t bold " the text tool"
	t normal " to edit state names and transition labels\n\n"

	t normal "All tools use the left button.  The middle button acts like the arrow's left button for the other three tools.\n\n"

	t bold "The arrow tool:\n"
	t normal " Select states by clicking their outlines or names.\n"
	t normal " Select transitions by clicking their lines or labels.\n"
	t normal " Change a selected object's shape by dragging its handles.\n"
	t normal " Move states by dragging their outlines.\n"
	t normal " Edit an object's attributes (color, font, etc.) by double-clicking it.\n\n"

	t bold "The state tool:\n"
	t normal " Create a new state by dragging out its outline.\n\n"

	t bold "The transition tool:\n"
	t normal " Create a new transition by dragging from the interior of one state to another.\n"
	t normal " Create a self-loop by dragging within a single state.\n\n"

	t bold "The text tool:\n"
	t normal " Edit a state's name or a transition's label by clicking on them and typing\n\n"

	t medbold "View Controls\n\n"

	t normal "A view starts at a particular state in the hierarchy and displays states below it to a certain depth.\n\n"

	t bold "The zoom buttons"
	t normal " (magnifying glasses):\n"
	t normal " Double or halve the magnification by pressing the buttons with no states selected\n"
	t normal " Start the view on a state by selecting it and pressing the zoom-in button\n"
	t normal " Start the view on a state's parent by selecting the state and pressing the zoom-out button\n\n"

	t bold "The depth buttons"
	t normal " (rectangles enclosing rectangles):\n"
	t normal " To reduce the depth (display fewer states), click on the top button\n"
	t normal " To increase the depth (display more states), click on the botom button\n\n"

	t medbold "Pull-Down Menus\n\n"

	t bold "The View Menu:\n"
	t bold " Full"
	t normal " sets the view to the topmost state with magnification 1.\n"
	t bold " Print to File"
	t normal " writes a PostScript rendering of the current view to a filename you specify\n"
	t bold " Close"
	t normal " dismisses the current view window.\n\n"

	t bold "The Edit Menu:\n"
	t bold " Cut"
	t normal " deletes the selected objects.\n\n"

	$te configure -state disabled
	
    }

}
