#!/home/tcltk/bin/itcl_wish -f

# set sampletext "The quick brown fox jumps over the lazy dog"

set slantName(r) Roman
set slantName(i) Italic
set slantName(o) Oblique

proc menuline {val {setval {}} } {
    upvar this t
    upvar m menu
    upvar option o
    if { $setval != "" } {
	$menu add command -label $val -command "$t config -$o $setval" 
    } else {
	$menu add command -label $val -command "$t config -$o $val"
    }
}

##############################
#
# FontChooser
#
# font selection widget
#
# -fontobject
#

itcl_class FontChooser {

    constructor {config} {

	global fontName

	set class [$this info class]
	::rename $this $this-tmp-
	::frame $this -class $class
	::rename $this $this-win-
	::rename $this-tmp- $this

#	entry $this.e -state disabled -textvariable sampletext 
#	pack $this.e -side top -anchor w -fill x -expand y -padx 5 -pady 2

#	bind $this.font <Return> "$this setfont"

	#trace variable fontName($this) w "$this setfont"

	set m $this.family.m
	menubutton $this.family -width 10 -text "Family" -menu $m -relief raised -bd 2
	menu $m
	set option family
	menuline Times
	menuline Helvetica
	menuline Courier

	set m $this.weight.m
	menubutton $this.weight -width 10 -text "weight" -menu $m -relief raised -bd 2
	menu $m
	set option weight
	menuline Medium
	menuline Bold

	set m $this.slant.m
	menubutton $this.slant -width 10 -text "slant" -menu $m -relief raised -bd 2
	menu $m
	set option slant
	menuline Roman r
	menuline Oblique o
	menuline Italic i

	set m $this.point.m
	menubutton $this.point -width 5 -text "10pt" -menu $m -relief raised -bd 2
	menu $m
	set option point
	menuline 6pt 60
	menuline 7pt 70
	menuline 8pt 80
	menuline 9pt 90
	menuline 10pt 100
	menuline 11pt 110
	menuline 12pt 120
	menuline 14pt 140
	menuline 18pt 180
	menuline 21pt 210
	menuline 24pt 240
	menuline 36pt 360
	menuline 48pt 480
	menuline 60pt 600
	menuline 72pt 720

	frame $this.f
	lower $this.f

	pack $this.family $this.weight $this.slant $this.point -in $this.f\
	    -side left -ipadx 2 -ipady 2 -padx 1 -pady 3
	pack $this.f -side top -anchor n

#	tk_menuBar $this $this.family $this.weight $this.slant $this.point

	entry $this.font -textvariable fontName($this) -relief sunken -bd 2
	pack $this.font -side top -anchor w -fill x -expand y -padx 5 -pady 2

	config
    }

    destructor {
	global fontName

	unset fontName($this)

	::rename $this-win- {}
	destroy $this
    }

    method config {config} {

	global slantName fontName

	if { $fontchanged } {
	    regsub -all {[-]} $font " " nospace
	    scan $nospace " * %s %s %s normal  * %s *" \
		family weight slant point
	} else {
	    set font "-*-$family-$weight-$slant-normal--*-$point-*"
	}
		 
	set fontName($this) $font

	$this.family config -text $family
	$this.weight config -text $weight
	$this.slant config -text $slantName($slant)
	$this.point config -text [expr $point / 10]pt
	if { $fontobject != "" } {
	    if [catch {$fontobject config -font $font}] {
		config -font $lastfont
	    }
	}

	set fontchanged 0

	set lastfont $font
    }

    method get {} {
	return $font
    }

    method setfont {} {
	global fontName
	config -font $fontName($this)

    }

    public family {Times}
    public weight {Medium}
    public slant {r}
    public point {120}

    public font {} {set fontchanged 1}

    public lastfont {}

    protected fontchanged {0}

    # configured with -font $font when it changes

    public fontobject	{}

}

# FontChooser .fc
# button .b -text "Bye" -command "destroy ."
# pack .fc .b
