#
# Editor class
#

itcl_class Editor {

    constructor {givenRoot givenDepth givenZoom} {
	set w .[string tolower $this]

	toplevel $w
	wm minsize $w 100 100

	# The Menu Bar

	frame $w.menu -relief raised -bd 2
	pack $w.menu -side top -fill x

	# The View menu

	set m $w.menu.view.m
	menubutton $w.menu.view -text "View" -menu $m -underline 0
	pack $w.menu.view -side left
	menu $m
	$m add command -label "Full" -command "$this menuFull" \
	    -underline 0
	$m add separator
	$m add command -label "Print to file" -command "$this menuPrint" \
	    -underline 0
	$m add separator
	$m add command -label "Close" -command "$this delete" \
	    -underline 0

	# The Edit menu

	set m $w.menu.edit.m

	menubutton $w.menu.edit -text "Edit" -menu $m -underline 0
	pack $w.menu.edit -side left
	menu $m
#	$m add command -label "Undo" -command "menuUndo $w" -underline 0 \
	    -accelerator "M-z"
#	$m add separator
	$m add command -label "Cut" -command "$this menuCut" -underline 0
#	$m add command -label "Copy" -command "menuCopy $w" -underline 1 \
	    -accelerator "M-c" -state disabled
#	$m add command -label "Paste" -command "menuPaste $w" -underline 0 \
	    -accelerator "M-v"
	
	# The Help menu
	
	set m $w.menu.help.m
	menubutton $w.menu.help -text "Help" -menu $m -underline 0
	pack $w.menu.help -side right
	menu $m
	$m add command -label "About..." -command "HelpAbout \#auto" \
	    -underline 0
	$m add separator
	$m add command -label "On Editing" -command "HelpEditing \#auto" \
	    -underline 3

	tk_menuBar $w.menu $w.menu.view $w.menu.edit $w.menu.help

	# The tool palette

	global tools toolBitmap

	frame $w.p

	foreach tool $tools {
	    button $w.p.$tool -bitmap $toolBitmap($tool) \
		-command "$this selectTool $tool"
	    pack $w.p.$tool -side top
	}

	global bmd

	button $w.p.zoomout -bitmap @$bmd/zoomout.xbm -command "$this zoomout"
	label $w.p.zoom -text "1x"
	button $w.p.zoomin -bitmap @$bmd/zoomin.xbm -command "$this zoomin"

	button $w.p.shallow -bitmap @$bmd/shallow.xbm -command "$this shallower"
	label $w.p.depth -text "d=1"
	button $w.p.deep -bitmap @$bmd/deep.xbm -command "$this deeper"
	pack $w.p.deep $w.p.depth $w.p.shallow \
	    $w.p.zoomin $w.p.zoom $w.p.zoomout -side bottom

	pack $w.p -side left -fill y

	# The Canvas

	frame $w.can

	canvas $w.c -scrollregion {0i 0i 8.5i 11i} \
	    -xscroll "$w.hscroll set" -yscroll "$w.vscroll set" \
	    -relief raised -bd 2 \
	    -scrollincrement 1
	scrollbar $w.hscroll -orient horiz -command "$w.c xview" \
	    -relief raised -bd 2
	scrollbar $w.vscroll -orient vert -command "$w.c yview" \
	    -relief raised -bd 2
    
	pack $w.hscroll -side bottom -fill x -in $w.can
	pack $w.vscroll -side right -fill y -in $w.can
	pack $w.c -side left -fill both -expand yes -in $w.can
	pack $w.can -fill both -expand yes
	
	set view [View \#auto $w.c -viewAction "$this setView"]
	$view setView $givenRoot $givenDepth $givenZoom
	setView

	selectTool arrow
    }

    destructor {
	$view delete
	destroy $w
    }

    method windowOf {} {return $w}
    method viewOf {} {return $view}

    method recreate {} {
	return "Editor {$this} {[$view rootOf]} {[$view depthOf]} {[$view zoomOf]}"
    }

    # called to set the correct view status

    method setView {} {
	global currentFile
	wm title $w "[file tail $currentFile]: [$view rootOf]"
	$w.p.zoom config -text "[$view zoomOf]x"
	$w.p.depth config -text "d=[$view depthOf]"
    }

    method selectTool {requestedTool} {

	global stActiveBackground stActiveForeground \
	    stBackground stForeground \
	    ustActiveBackground ustActiveForeground \
	    ustBackground ustForeground \
	    toolCursor bindings boundproc bindAArgs

	# unhighlight the current tool

	if { $tool != "" } {
	    $w.p.$tool config -activebackground $ustActiveBackground
	    $w.p.$tool config -activeforeground $ustActiveForeground
	    $w.p.$tool config -background $ustBackground
	    $w.p.$tool config -foreground $ustForeground
	}

	set tool $requestedTool

	$w.c config -cursor $toolCursor($tool)

	foreach binding [array names bindings] {
	    if [info exists boundproc($tool$binding)] {
		set proc $boundproc($tool$binding)
		regsub "%v" $bindAArgs($proc) $view aargs
		bind $w.c $bindings($binding) "$proc $aargs"
	    } else {
		bind $w.c $bindings($binding) ""
	    }
	}

	$w.p.$tool config -activebackground $stActiveBackground
	$w.p.$tool config -activeforeground $stActiveForeground
	$w.p.$tool config -background $stBackground
	$w.p.$tool config -foreground $stForeground

    }

    method shallower {} {
	set depth [$view depthOf]
	if { $depth > 0 } {
	    $view setView [$view rootOf] [expr $depth - 1] [$view zoomOf]
	}
    }

    method deeper {} {
	$view setView [$view rootOf] [expr [$view depthOf] + 1] [$view zoomOf]
    }

    method zoomin {} {
	set s [$view firstSelectedState]
	if { $s != "" } {
	    $view setView $s [expr [$view depthOf] - 1] [expr [$view zoomOf] * 2.0]
	} else {
	    $view setZoom [expr [$view zoomOf] * 2.0]
	}
    }

    method zoomout {} {
	set s [$view firstSelectedState]
	if { $s != "" } {
	    set p [$s parentOf]
	    if { $p != "" } {
		$view setView $p [expr [$view depthOf] + 1] [expr [$view zoomOf] / 2.0 ]
	    } else {
		$view setZoom [expr [$view zoomOf] / 2.0 ]		
	    }
	} else {
	    $view setZoom [expr [$view zoomOf] / 2.0]
	}
    }

    method menuFull {} {
	$view setView [State :: rootStateOf] 1 1.0
    }

    method menuPrint {} {
	global currentFile

	set printFile [ fileDialog .print[string tolower $this] Print \
			    "Save as Postscript file:" "Print" \
			    "[file rootname $currentFile].ps" ]

	if { $printFile != "" } { 
	    [$view canvasOf] postscript -file $printFile
	}

    }

    method menuCut {} {

	set rootstate [State :: rootStateOf]

	foreach o [$view getSelected] {
	    if { [itcl_info objects $o] != "" && $o != $rootstate } {
		$o delete
	    }
	}
      
    }
    
    # The toplevel window for this editor
    protected w

    # The view for this editor
    protected view

    # The tool currently in use in this editor
    protected tool {}

}
