import java.io.*;
import IcLexer;
import IcParser;
import IcWalker;
import antlr.collections.AST;

class Ic2Dot {
    public static void main(String[] args) {
	try {
	    IcLexer lexer = new IcLexer(new DataInputStream(System.in));
	    IcParser parser = new IcParser(lexer);

	    // set the type of tree node to create; this is default action
	    // so it is unnecessary to do it here, but demos capability.
	    // parser.setASTNodeType("antlr.CommonAST");

	    parser.file();
	    antlr.CommonAST ast = (antlr.CommonAST)parser.getAST();

	    /*
	    if (ast != null) {
		System.out.println(ast.toStringList());
	    } else {
		System.out.println("null AST");
	    }
	    */

	    IcWalker walker = new IcWalker();

	    walker.file(ast);

	} catch(Exception e) {
	    System.err.println("exception: "+e);
	}
    }
}
