#ifndef WW_H
#define WW_H

#define SIMUL

/*
\headline{\hss\it C code for the beeper\hss}
\Section{Handling beeps : Files ``BEEP.h'' and ``beep.c''}

\SubSection{The \BEEPTYPE\ type and its copy function}

\noindent
This is file ``BEEP.h''.
*/

#define BEEP_LOADED

/*
\noindent
\BEEPTYPE\ is just integer
*/

typedef int BEEP_TYPE;

/*
\noindent
Copying is just assignment
*/

#define _BEEP_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
No equality function is needed
*/

/*
\SubSection{Some constants}
*/

#define NO_BEEP_VALUE 0

#define ONE_BEEP 1

#define TWO_BEEPS 2

#define THREE_BEEPS 3

#define FOUR_BEEPS 4

/*
\headline={\hss\nineit C code for the \WATCH\ module\hss}
\Section{File ``WATCH.h'': types and defined
constants for the \WATCH\ module}
*/

#define WATCH_LOADED

/*
\SubSection{The \WATCHTIMETYPE\ type and its copy function}
*/

typedef struct {int day_in_week;
                int month;
                int day;
                int hours;
                int minutes;
                int seconds;
                int mode12h;} WATCH_TIME_TYPE;

/*
\noindent
Copying is simply done by assignment :
*/

#define _WATCH_TIME_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
Equality is never used and needs not be declared.
*/

/*
\SubSection{ The \WATCHTIMEPOSITION\ type and its copy function}
*/

typedef int WATCH_TIME_POSITION;

/*
\noindent
Copying is simply done by assignment :
*/

#define _WATCH_TIME_POSITION(X,Y) (*(X)=(Y))

/*
\noindent
Equality is never used.
*/

/*
\SubSection{The \INITIALWATCHTIMEPOSITION\ constant}
*/

#define INITIAL_WATCH_TIME_POSITION 0

/*
\SubSection{The \WATCHBEEPVALUE\ constant}

\noindent
This constant is defined only if the \LOADBEEP\ flag is \#defined
*/

#define WATCH_BEEP_VALUE TWO_BEEPS


/*
\headline={\hss\nineit C code for the \STOPWATCH\ module\hss}
\Section{File ``stopwatch.h'' : types and defined constants for
the \STOPWATCH\ module}
*/

#define STOPWATCH_LOADED

/*
\SubSection{The \STOPWATCHTIMETYPE\ type and its copy function}
*/

typedef struct {int hundredths;
                int seconds;
                int minutes;} STOPWATCH_TIME_TYPE;

/*
\noindent
Copying is simply done by assignment :
*/

#define _STOPWATCH_TIME_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
Equality is never used.
*/

/*
\SubSection{The \STOPWATCHBEEPVALUE\ constant}

\noindent
This constant is defined only if the \LOADBEEP\ flag is \#defined
*/


#define STOPWATCH_BEEP_VALUE ONE_BEEP

/*
\SubSection{Time handling constants}
*/

#ifdef SIMUL

#define HUNDREDTHS_PER_INCREMENT 1
#define HUNDREDTHS_PER_SECOND 2
#define SECONDS_PER_MINUTE 2
#define MINUTES_PER_HOUR 2
#define MINUTES_TO_BEEP 1

#else

extern int HUNDREDTHS_PER_INCREMENT;
#define HUNDREDTHS_PER_SECOND 100
#define SECONDS_PER_MINUTE 60
#define MINUTES_PER_HOUR 60
#define MINUTES_TO_BEEP 1 /* should be 10, but set to 1 for demos */

#endif


/*
\headline={\hss\nineit C code for the \ALARM\ module\hss}
\Section{File ``alarm.h'' : types and defined
constants for the \ALARM\ module}
*/

#define ALARM_LOADED

/*
\SubSection{The \ALARMTIMETYPE\ type and its copy function}
*/

typedef struct {int hours;
                int minutes;
                int mode12h;} ALARM_TIME_TYPE;

/*
\noindent
Copying is simply done by assignment :
*/

#define _ALARM_TIME_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
Equality is never used.
*/

/*
\SubSection{The \ALARMTIMEPOSITION\ type and its copy function}

\noindent
The type is just integer
*/

typedef int ALARM_TIME_POSITION;

/*
\noindent
Copying is simply done by assignment :
*/

#define _ALARM_TIME_POSITION(X,Y) (*(X)=(Y))

/*
\noindent
Equality is never used.
*/

/*
\SubSection{The \INITIALALARMTIMEPOSITION\ constant}
*/

#define INITIAL_ALARM_TIME_POSITION 0

/*
\SubSection{The \ALARMDURATION\ constant}
*/

#ifdef SIMUL

#define ALARM_DURATION 3

#else

#define ALARM_DURATION 30

#endif

/*
\SubSection{The \ALARMBEEPVALUE\ constant}

\noindent
This constant is defined only if the \LOADBEEP\ flag is \#defined.
*/

#define ALARM_BEEP_VALUE FOUR_BEEPS

/*
\SubSection{Loading the WATCH.h definitions}
*/

/*
\headline={\hss\nineit C code for the \DISPLAY\ module\hss}
\Section{File ``display.h'' : types and defined
constants for the \DISPLAY\ module}
*/

#define DISPLAY_LOADED

/*
\SubSection{The \MAINDISPLAYTYPE\ type and its copy function}
*/

#ifdef SIMUL

typedef struct {char hours[3]; 
                char minutes[3];
                char seconds [4]; /* for the trailing : */
                char timemode[5];} MAIN_DISPLAY_TYPE;

#else

typedef struct {char hours[3]; 
                char minutes[3];
                char seconds [3];
                char timemode[4];} MAIN_DISPLAY_TYPE;

#endif

/*
\noindent
Copying is simply done by assignment :
*/

#define _MAIN_DISPLAY_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
No equality function is needed.
*/

/*
\SubSection{The \MINIDISPLAYTYPE\ type and its copy function}
*/

typedef struct {char fst[3];
                char sep[2];
                char snd[3];} MINI_DISPLAY_TYPE;

/*
\noindent
Copying is simply done by assignment :
*/

#define _MINI_DISPLAY_TYPE(X,Y) (*(X)=(Y))

/*
\noindent
No equality function is needed.
*/

/*
\SubSection{ the \DISPLAYPOSITION\ type and its copy function}
*/

typedef int DISPLAY_POSITION;

/*
\noindent
Copying is simply done by assignment :
*/

#define _DISPLAY_POSITION(X,Y) (*(X)=(Y))

/*
\noindent
No equality function is needed.
*/

#endif
