// -*- C++ -*-

//////////////////////////////
//
// Set class
//
// Usage:
//
// setc fred(10);
//
// fred |= 3;
// fred |= 5;
// fred.memberof(2)	/* == 0 */
// fred.memberof(5)	/* == 0 */
//
// setc george(10);
//
// george |= fred;

class setc {
  int * entries;	// array---entries are non-zero if members
  int n_entries;

public:

  setc( int n ) { n_entries = n;
		  entries = new int [n]; 
		  for ( ; --n >= 0 ; ) entries[n] = 0;
		}

  ~setc() { delete [] entries; }

  int size() { return n_entries; }

  int memberof( int k ) { return entries[k]; }

  int cardinality() { int c;
		      for ( int i = n_entries ; --i >= 0 ; ) 
			c += entries[i];
		      return c;
		    }

  // Add an integer k to the set

friend
  setc & operator |= ( setc & s1, int k );

  // Add every element in set s2 to set s1

friend
  setc & operator |= ( setc & s1, setc & s2 );

  // Remove every element in set s2 from set s1

friend
  setc & operator -= ( setc & s1, setc & s2 );

friend
  ostream & operator << ( ostream & s, setc & s1 );
};

inline
setc & operator |= ( setc & s1, int k ) {
  s1.entries[k] |= 1;
  return s1;
}

inline
setc & operator |= ( setc & s1, setc & s2 ) {
  for ( int i = s1.n_entries ; --i >= 0 ; )
    s1.entries[i] |= s2.entries[i];
  return s1;
}

inline
setc & operator -= ( setc & s1, setc & s2 ) {
  for ( int i = s1.n_entries ; --i >= 0 ; )
    if ( s2.entries[i] )
      s1.entries[i] = 0;
  return s1;
}

inline
ostream & operator << ( ostream & s , setc & s1 ) {
  s << "{ ";
  for ( int i = 0 ; i < s1.n_entries ; i++ )
    if ( s1.entries[i] ) s << i << ' ';
  s << '}';
  return s;
}
