%{ // -*- C++ -*-

// (f)lex grammar for Esterel

#include "est.h"
#include "gram.h"

int yylineno = 1;

extern YYLTYPE yylloc;

#define STRINGTABLESIZE 701

stringtable strings(STRINGTABLESIZE);	// The string table

// The first thing yyparse() does upon entry:

#define YY_USER_ACTION \
yylloc.first_line = yylineno;

// always assume this is the last file

#define yywrap() 1

%}

LETTER		[A-Za-z]
DIGIT		[0-9]
INTEGER		-?[0-9]+
ID		{LETTER}({LETTER}|{DIGIT}|_)*
WHITESPACE	[ \t\f]+
SINGLECHAR	[+\-*/<>.,=;:()\]\[]

%%

%[^\n]*\n	{ yylineno++; }
\n		{ yylineno++; }

{WHITESPACE}	{ }

"and"		{ return(And             ); }
"await"		{ return(Await           ); }
"call"		{ return(Call            ); }
"case"		{ return(Case            ); }
"combine"      	{ return(Combine         ); }
"constant"	{ return(Constant        ); }
"copymodule"	{ return(Copymodule      ); }
"do"		{ return(Do              ); }
"each"		{ return(Each            ); }
"else"		{ return(Else            ); }
"emit"		{ return(Emit            ); }
"end"		{ return(End             ); }
"every"		{ return(Every           ); }
"exit"		{ return(Exit            ); }
"false"		{ return(False           ); }
"function"	{ return(Function        ); }
"halt"		{ return(Halt            ); }
"handle"	{ return(Handle          ); }
"if"		{ return(If              ); }
"immediate"	{ return(Immediate       ); }
"in"		{ return(In              ); }
"input"		{ return(Input           ); }
"inputoutput"	{ return(Inputoutput     ); }
"loop"		{ return(Loop            ); }
"mod"		{ return(Mod             ); }
"module"	{ return(Module          ); }
"not"		{ return(Not             ); }
"nothing"	{ return(Nothing         ); }
"or"		{ return(Or              ); }
"output"	{ return(Output          ); }
"present"	{ return(Present         ); }
"procedure"	{ return(Procedure       ); }
"relation"	{ return(Relation        ); }
"repeat"	{ return(Repeat          ); }
"sensor"	{ return(Sensor          ); }
"signal"	{ return(Signal          ); }
"sustain"	{ return(Sustain	 ); }
"then"		{ return(Then            ); }
"timeout"	{ return(Timeout         ); }
"times"		{ return(Times           ); }
"trap"		{ return(Trap            ); }
"true"		{ return(True            ); }
"type"		{ return(Type            ); }
"upto"		{ return(Upto            ); }
"var"		{ return(Var             ); }
"watching"	{ return(Watching        ); }
"with"		{ return(With            ); }

"integer"	{ return(Integer	 ); }
"boolean"	{ return(Boolean	 ); }

":="		{ return(ColEq		 ); }

"<="		{ return(LE		 ); }
">="		{ return(GE		 ); }
"<>"		{ return(NE		 ); }

"??"		{ return(ExceptionVal	 ); }
"?"		{ return(SignalVal	 ); }

"||"		{ return(ParComp	 ); }

{SINGLECHAR}	{ return(yytext[0]	 ); }

{INTEGER}	{ yylval.i = atoi(yytext); return(IntLit); }
{ID}		{ yylval.s = strings.add(yytext); return(ID); }

%%

//////////////////////////////
//
// String table methods
//

ostream &
operator << ( ostream & s, stringtable & st )
{
  stringtable::entry * e;
  for (int i = st.tablesize ; --i >= 0 ; ) {
    for ( e = st.entries[i] ; e ; e = e->next )
      s << e->string << ' ';
  }
  s << '\n';
  return s;
}

