// -*- C++ -*-

// Main routine for the Esterel compiler

// Stephen Edwards

// for file manipulation
#include <fstream.h>

// for yyin manipulation
#include <stdio.h>

// for exit()
#include <stdlib.h>

#include "est.h"

// in "scan.l"

extern FILE * yyin;

char * TICKstring;

ASTdeclaration * TICKdecl;
sd * TICKsd;

int asmdebug;

YYLTYPE nowhereloc = { 0,0,0,0,0 };

extern "C" int getopt( int argc, const char * argv[], const char * optstring);
extern char * optarg;
extern int optind;

main( int argc, char * argv[] )
{
  int c;

  int usageflg = 0;
  int errflg = 0;
  int showstrings = 0;
  int showast = 0;
  int showtrans = 0;
  int assemblef = 0;

  asmdebug = 0;

  ostream * asout = &cout;

  while ( ( c = getopt(argc, argv, "satSo:g")) != -1 )
    switch (c) {
    case 's':
      showstrings = 1;
      break;
    case 'a':
      showast = 1;
      break;
    case 't':
      showtrans = 1;
      break;
    case 'S':
      assemblef = 1;
      break;
    case 'o':
      assemblef = 1;
      asout = new ofstream(optarg);
      break;
    case 'g':
      asmdebug = 1;
      break;
    case '?':
      errflg = usageflg = 1;
      break;
    };

  // If there is an argument left, it is the source filename---open it

  if ( optind < argc ) {
    yyin = fopen( argv[optind] , "r" );
    if (!yyin) {
      cerr << "Unable to open source file `" << argv[optind] << "'\n";
      errflg = 1;
    }
  }

  if (errflg) {
    if ( usageflg )
      cerr << "Usage: est [options] [inputfile]\n"
	"-s" TAB TAB "dump the string table\n"
	"-a" TAB TAB "dump the AST\n"
	"-t" TAB TAB "dump the translation\n"
	"-S" TAB TAB "assemble\n"
	"-g" TAB TAB "include debugging information\n"
	"-o outputfile" TAB "specify assembly output file (forces -S)\n"
	;

    exit(1);
  }

  // Initialization for parsing

  TICKstring = strings.add("TICK");

  // parse the source file into   ASTmodule * theprogram

  yyparse(); if ( nerrs ) bail();

  // Dump the string table if requested

  if (showstrings) {
    cout << "String table: " << strings;
  }

  // Dump the AST if requested

  if (showast) {
    cout << "AST:\n";
    cout << *theprogram;
  }

  // Initialization for static sematics

  TICKdecl = new ASTdeclaration(nowhereloc, TICKstring);
  TICKdecl->setflavor(INPUT);
  TICKsd = new sd(SDsig, TICKdecl);
  TICKdecl->setsd(TICKsd);
  signals.pushsym( TICKdecl );

  // Perform the static semantic checks

  theprogram->semant(); if ( nerrs ) bail();

  if (showtrans) {
    TICKsd->printsd(cout);
  }

  // Translate the semantic-checked program into the intermediate form

  amprocess amtranslation;

  theprogram->translate(amtranslation);

  amtranslation.addexit();

  // Count and assign the program counters

  amtranslation.countpc();

  if ( showtrans ) {
    cout << "Translation:\n";
    for ( int j = 0 ; j < amtranslation.n_processes() ; j++ )
      cout << *(amtranslation.process(j));
    cout << "\n" << amtranslation.n_pcs() << " program counters total\n";
  }

  if ( assemblef ) {
    assemble( *asout, amtranslation );
    dumpvartab( *asout, *TICKsd );
  }

  exit(0);
}

