// -*- C++ -*-

// Header file for the Esterel compiler

// Stephen Edwards

#include <string.h>
#include <stream.h>

#include "array.h"
#include "set.h"
#include "ast.h"
#include "am.h"
#include "parse.h"


#define TAB	"\t"
#define NL	"\n"

//////////////////////////////
//
// Definition of ostream manipulators 
//
// Usage:
//
// OMANIP0( foo ) {
//	s << "this is a foo";
//	return s;
// }
//
// OMANIP1( bar, int ) {
//	s << f(i);	// i is the parameter
//	return s;
// }
//
// cout << foo << bar(1);
//

template<class T> class OMANIP1_C {
  T i;
  ostream & (*f)( ostream &, T );
public:
  OMANIP1_C( ostream & (*ff)( ostream &, T ), T ii )
  : f(ff), i(ii) {}

  friend ostream & operator << ( ostream & s, OMANIP1_C & m )
  { return m.f( s, m.i ); }

};

#define OMANIP1( function, type ) \
	extern ostream & _os_##function( ostream &, type ); \
	inline OMANIP1_C<type> function ( type n ) \
	{ return OMANIP1_C<type> (_os_##function, n); } \
	ostream & _os_##function( ostream & s, type i )

typedef ostream & ( OMANIP0 )( ostream & );

inline ostream & operator << ( ostream & s, OMANIP0 f)
{ return f(s); }

#define OMANIP0( function ) \
	ostream & s function ( ostream & s )

//////////////////////////////////////////////////////////////////////
//
// External Declarations
//

// in "scan.l"

extern stringtable strings;

extern int yylex();

// in "gram.y"

extern symtab variables;
extern symtab signals;		// inputs, output, inputoutputs, local signals
extern symtab exceptions;

extern int nerrs;		// number of errors which have been encountered
#define MAXERRORS 10

extern ASTmodule * theprogram;	// the AST for the program

extern void yyerror( char * s, astnode * node = 0, char * t = 0 );
extern void yywarning( char * s, astnode * node = 0, char * t = 0 );
extern void bail();

extern int yyparse();

// in "sparc.cc"

extern void assemble( ostream & s, amprocess & se);
extern void assembleprocess( ostream & s, amprocess & se);
extern void dumpvartab( ostream & s, sd & thevars);

// in "main.cc"

extern char * TICKstring;	// unique reference to "TICK"
extern ASTdeclaration * TICKdecl;
extern sd * TICKsd;

extern int asmdebug;		// assember debug mode


