/* -*- C -*- */

/*
 *
 * Command-line interface to Esterel compiler
 *
 */

#include <stdio.h>

#define ARGS(x)

extern clearsignals();

extern int simtick( ARGS( int debug ) );

#define STATUSTERMINATED 0
#define STATUSHALT 1

extern void initialize();

extern printarrays();

extern printsignals();

typedef struct {
  char * name;
  int globalinput;
  char * sigpres;
  int * sigval;
} sig_t;

#define SIGPRESENT 1
#define SIGUNKNOWN 0
#define SIGABSENT -1

extern sig_t sigs[];

extern int n_sig;

#define BUFSIZE 128

char inputline[BUFSIZE];

int myargc;
char * myargv[10];


/* splitline() --- Break the line into space-separated tokens */

splitline( line )
char * line;
{
  myargc = 0;

  while ( *line != '\0' && *line != '\n') {
    myargv[myargc++] = line;
    while ( *line != ' ' && *line != '\n' )
      line++;
    *line++ = '\0';
    while ( *line == ' ')
      line++;
  }

}

/* sigofname() --- find a signal from its name */

int
sigofname( n )
char * n;
{
  int i;

  for ( i = n_sig; --i >= 0 ; )
    if ( strcmp( sigs[i].name, n ) == 0 )
      break;

  return i;
}

main()
{
  int debug = 0;
  int quitflag;
  int i, index;

  setlinebuf( stdin );

  initialize();

  do {
    quitflag = 0;
    
    printf("est> ");
    fgets( inputline, BUFSIZE, stdin );
    splitline( inputline );

    if ( myargc != 0 ) {
      switch ( myargv[0][0] ) {

      case 't':
	if ( simtick(debug) == STATUSTERMINATED )
	  printf("Program terminated\n");
	printsignals();
	clearsignals();
	break;

      case 'p':
	for ( i = 1 ; i < myargc ; i++ ) {
	  if ( ( index = sigofname( myargv[i] ) ) >= 0 )
	    *(sigs[index].sigpres) = SIGPRESENT;
	  else
	    printf("Signal `%s' unknown\n",myargv[i]);
	}
	break;

      case 'a':
	for ( i = 1 ; i < myargc ; i++ ) {
	  if ( ( index = sigofname( myargv[i] ) ) >= 0 )
	    *(sigs[index].sigpres) = SIGABSENT;
	  else
	    printf("Signal `%s' unknown\n",myargv[i]);
	}
	break;

      case 'u':
	for ( i = 1 ; i < myargc ; i++ ) {
	  if ( ( index = sigofname( myargv[i] ) ) >= 0 )
	    *(sigs[index].sigpres) = SIGUNKNOWN;
	  else
	    printf("Signal `%s' unknown\n",myargv[i]);
	}
	break;

      case 'l':
	for ( i = 1 ; i < myargc ; i += 2 ) {
	  if ( ( index = sigofname( myargv[i] ) ) >= 0 ) {
	    if ( sigs[i].sigval ) {
	      *(sigs[i].sigval) = atoi( myargv[i+1] );
	      *(sigs[i].sigpres) = SIGPRESENT;
	    } else {
	      printf("Signal `%s' is not valued\n",myargv[i]);
	    }
	  } else {
	    printf("Signal `%s' unknown\n",myargv[i]);
	  };
	};
	break;

      case 'r':
	printarrays();
	break;

      case 'd':
	if ( myargc == 1 )
	  debug = 0;
	else
	  debug = atoi(myargv[1]);
	if ( debug )
	  printf("debug is at level %d\n",debug);
	else
	  printf("debug is off\n");
	break;

      case 'R':
	initialize();
	break;

      case 'e': case 'q':
	quitflag = 1;
	break;

      default:
	fprintf(stderr,
		"t\t\tAdvance time\n"
		"p s1 s2 ..\tPlace an event on the named pure signals\n"
		"a s1 s2 ..\tForce named signals to be absent\n"
		"l s1 v1 s2 v2 ..\tPlace a valued event on the named signals\n"
		"r\t\tDump all internal arrays\n"
		"R\t\tReset everything\n"
		"d level\tSet debug to given level\n"
		"q or e\t\tExit the program\n");
	break;
      }

    }

  } while ( quitflag == 0 );

  exit(0);

}
