// -*- C++ -*-

// Template for variable-sized arrays which grow as necessary

//////////////////////////////
//
// The Array Class
//
// Template for variable-size arrays which grow when necessary
//
// Usage:
//
// array<int> fred;
//
// fred[i] = 10;
// george = fred[j];
// cout << fred;		// dump each element in the array

template<class T>
class array {

  T * thearray;
  int themax;
  int thesize;

  void  resize(int s);          // resize the array

public:
  array(int n = 16) {		// Create an empty one with a size
    thesize = 0;
    themax = n; 
    thearray = new T [themax];
  };

  ~array() { delete[] thearray; }

  int   size() const { return thesize; }
  int   max() const { return themax; }

  T & operator [] (const int i);        // may resize array
};

template<class T>
T & array<T>::operator [] (const int i){
  if (i >= thesize)
    array::resize(i+1);

  return thearray[i];
}

template<class T>
void array<T>::resize (int s)
{
  if (s > thesize && s > themax ) {
    do { themax *= 2; } while ( s > themax ) ;
    T * newarray = new T[themax];
    for (int i = thesize ; --i >= 0 ; )
      newarray[i] = thearray[i];
    delete[] thearray;
    thearray = newarray;
  }

  thesize = s;
}

template<class T>
ostream & operator << (ostream & s, array<T> & ar)
{
  for (int i = 0; i < ar.size() ; i++ )
    s << ar[i] << ' ';

  return s;
}
