// -*- C++ -*-

// AM-related functions for the Esterel compiler

// Stephen Edwards

#include "est.h"

#define PRINT(x) void x::print( ostream & s )
#define COUNTPC(x) int x::countpc( int pcin = 0 , int pcmax = 0 )
#define POTENTIALOF(x) void x::potentialof( setc & s )

#define COMMENT "! "
#define PRINTINDEX  indexof() << ": "

// Initialize the static members of the amprocess class

int amprocess::pccount = 0;
array<amprocess *> amprocess::processes;

ostream & operator << ( ostream & s, sd & sd1 )
{
  switch( sd1.type ) {
  case SDreg:
    s << 'r' << sd1.arg;
    break;
  case SDvar:
    s << 'v' << sd1.arg;
    break;
  case SDsig:
    s << 's' << sd1.arg;
    break;
  case SDcntr:
    s << 'c' << sd1.arg;
    break;
  case SDexc:
    s << 'e' << sd1.arg;
    break;
  case SDconst:
    s << sd1.arg;
    break;
  default:
    s << "unknown sd";
    break;
  }

  return s;
}

ostream & operator << ( ostream & s, amnode & n)
{
  n.print(s);
  return s;
}

ostream & operator << ( ostream & s, amprocess & p )
{

  p.printheader(s);

  for ( int i = 0 ; i < p.size() ; i++ )
    p[i]->print(s);

  s << NL;

  return s;
}

void amprocess::printheader( ostream & s )
{
  s << COMMENT "Process P" << processnumber();
  if ( parentof() )
    s << " of process P" << parentof()->processnumber();
  s << " uses PC" << pcof() << NL;

}

void AMrequire::addsignal(sd * s)
{
  for (int i = n_signals() ; --i >= 0 ; )
    if ( signal(i)->argof() == s->argof() ) return;

  signals[n_signals()] = s;
}

void amprocess::addexit()
{
  if ( size() == 0 || (*this)[size()-1]->terminates() )
    (*this) , new AMexit;
}

//////////////////////////////
//
// The print virtual function for each amnode
//

PRINT(amnode) {
  s << "ERROR: print called on a pure amnode\n";
}

PRINT(AMexit) {
  s << COMMENT << PRINTINDEX << "exit ";
  if ( exceptionof() ) s << *exceptionof();
  if ( registerof() ) s << ' ' << *registerof();
  s << NL;
}

PRINT(AMhalt) {
  s << COMMENT << PRINTINDEX << "halt";
  s << NL;
}

PRINT(AMassign) {
  s << COMMENT << PRINTINDEX << *destof() << " := ";
  if ( src2of() ) s << *src1of() << ' ';
  switch( opof() ) {
  case amASSIGN: break;
  case amNEG: s << "- "; break;
  case amNOT: s << "not "; break;
  case amDEC: s << "dec "; break;
  case amAND: s << "and "; break;
  case amOR:  s << "or "; break;
  case amEQ:  s << "= "; break;
  case amNE:  s << "!= "; break;
  case amLT:  s << "< "; break;
  case amLE:  s << "<= "; break;
  case amADD: s << "+ "; break;
  case amSUB: s << "- "; break;
  case amMUL: s << "* "; break;
  case amDIV: s << "/ "; break;
  case amMOD: s << "mod "; break;
  default: s << "unknown op!"; break;
  }
  if ( src2of() ) s << *src2of();
  else s << *src1of();

  s << NL;
}

PRINT(AMrequire) {
  s << COMMENT << PRINTINDEX << "require";
  for ( int j = n_signals() ; --j >= 0 ; )
    s << ' ' << *signal(j);
  s << NL;
}

PRINT(AMemit) {
  s << COMMENT << PRINTINDEX << "emit " << *signalof();
  if ( registerof() ) s << ' ' << *registerof();
  s << NL;
}

PRINT(AMbranch) {
  s << COMMENT << PRINTINDEX;
  if ( testof() ) {
    if ( senseof() ) s << "if not ";
    else s << "if ";
    s << *testof() << ' ';
  }
  s << "goto " << targetof() << NL;
}

PRINT(AMwatch) {
  s << COMMENT
    << "     watching " << *signalof() << ' ';
  if ( counterof() ) s << *counterof() << ' ';
  s << "goto " << targetof() << NL;
}

PRINT(AMhandle) {
  s << COMMENT
    << "     handle " << *exceptionof() << " goto " << targetof() << NL;
}

PRINT(AMtry) {
  int j;
  s << COMMENT << PRINTINDEX << "try\n";
  for ( j = 0 ; j < n_subprocesses() ; j++ )
    s << COMMENT "       call P" << subprocess(j)->processnumber() << NL ;

  for ( j = 0 ; j < n_watches() ; j++ )
    watch(j)->print(s);

  for ( j = 0 ; j < n_handles() ; j++ )
    handle(j)->print(s);

}

//////////////////////////////
//
// The countpc function for AM nodes
//

COUNTPC(amprocess)
{
  newpc(pcin);

  pc = pcin;
  
  for ( int i = 0 ; i < size() ; i++ ) {
    pcmax = (*this)[i]->countpc(pcin,pcmax);
  }

  return pcmax;
}

COUNTPC(AMtry)
{
  int p = pcin;

  for ( int i = 0 ; i < n_subprocesses() ; i++ ) {
    p = subprocess(i)->countpc(p+1,p+1);
    if ( p > pcmax ) pcmax = p;
  }

  return pcmax;
}

//////////////////////////////
//
// The potentialof function for AM nodes
//

POTENTIALOF(amnode) {}

POTENTIALOF(AMexit) {
// exit terminates a process---nothing more can be emitted
}

POTENTIALOF(AMhalt) {
// halt terminates a process---nothing more can be emitted
}

// next instruction can always be executed for assign and require

POTENTIALOF(AMassign) {
  nextinst()->potentialof(s);
}

POTENTIALOF(AMrequire) {
  nextinst()->potentialof(s);
}

// Add the emitted signal to the potential set

POTENTIALOF(AMemit) {
  s |= signalof()->argof();
  nextinst()->potentialof(s);
}

// If there is a test, then this is a conditional branch and the next
// instruction must be checked

POTENTIALOF(AMbranch) {
  if ( testof() )
    nextinst()->potentialof(s);
  (*processof())[targetof()]->potentialof(s);
}

// We are executing a try instruction in the first instant
//
// * each subprocess will be executed starting from the first
//   instruction
//
// * any of the exceptions may be raised (this is conservative)
//   look at the potential sets of all the handles
//
// * we assume it cannot terminate instantly without an exception, so
//   the next instruction is NOT checked

POTENTIALOF(AMtry) {
  int i;

  for ( i = n_subprocesses() ; --i >= 0 ; )
    (*subprocess(i))[0]->potentialof(s);

  for ( i = n_handles() ; --i >= 0 ; )
    (*processof())[handle(i)->targetof()]->potentialof(s);

}

