/*
 * "Hello World" for the EP2C5T144 minimum development board
 *
 * Count in binary on the three LEDs; press the button to make it count faster
 */

module hello(input        clk50,
	     input 	  KEY,
	     output [2:0] LED);
   
   logic [26:0] 	  count;   
   always_ff @(posedge clk50)
     count <= count + (KEY ? 27'd1 : 27'd4); // KEY = 0 when pressed
   
   assign LED = ~count[26:24];
   
endmodule
