{-# LANGUAGE BangPatterns #-}

module TicTacToe
  ( TTT(..)
  , Move
  , emptyTTT
  ) where

import qualified Data.Vector as V
import Control.DeepSeq (NFData(..))
import MCTS

type Move = Int  -- 0..8 symbolizing each cell

data TTT = TTT
  { board :: !(V.Vector (Maybe Player))  -- length 9
  , turn  :: !Player
  } deriving (Eq, Show)

instance NFData TTT where
  rnf (TTT b t) = rnf b `seq` rnf t

emptyTTT :: TTT
emptyTTT = TTT (V.replicate 9 Nothing) P1

instance Game TTT Move where
  currentPlayer = turn

  legalMoves s =
    [ i | i <- [0..8], board s V.! i == Nothing ]

  applyMove s m =
    let b = board s
        p = turn s
        b' = b V.// [(m, Just p)]
        p' = if p == P1 then P2 else P1
    in TTT b' p'

  terminal s =
    let b = board s
        line a c d =
          case (b V.! a, b V.! c, b V.! d) of
            (Just x, Just y, Just z) | x==y && y==z -> Just (Win x)
            _ -> Nothing
        wins =
          [ line 0 1 2, line 3 4 5, line 6 7 8
          , line 0 3 6, line 1 4 7, line 2 5 8
          , line 0 4 8, line 2 4 6
          ]
    in case [w | Just w <- wins] of
         (w:_) -> Just w
         []    ->
           if null (legalMoves s) then Just Draw else Nothing
